/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient.auth;

import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatPay2Validator
implements Validator {
    protected static final Logger log = LoggerFactory.getLogger(WechatPay2Validator.class);
    protected static final long RESPONSE_EXPIRED_MINUTES = 5L;
    protected final Verifier verifier;

    public WechatPay2Validator(Verifier verifier) {
        this.verifier = verifier;
    }

    protected static IllegalArgumentException parameterError(String message, Object ... args) {
        message = String.format(message, args);
        return new IllegalArgumentException("parameter error: " + message);
    }

    protected static IllegalArgumentException verifyFail(String message, Object ... args) {
        message = String.format(message, args);
        return new IllegalArgumentException("signature verify fail: " + message);
    }

    @Override
    public final boolean validate(CloseableHttpResponse response) throws IOException {
        try {
            this.validateParameters(response);
            String message = this.buildMessage(response);
            String serial = response.getFirstHeader("Wechatpay-Serial").getValue();
            String signature = response.getFirstHeader("Wechatpay-Signature").getValue();
            if (!this.verifier.verify(serial, message.getBytes(StandardCharsets.UTF_8), signature)) {
                throw WechatPay2Validator.verifyFail("serial=[%s] message=[%s] sign=[%s], request-id=[%s]", serial, message, signature, response.getFirstHeader("Request-ID").getValue());
            }
        }
        catch (IllegalArgumentException e) {
            log.warn(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public final String getSerialNumber() {
        return this.verifier.getSerialNumber();
    }

    protected final void validateParameters(CloseableHttpResponse response) {
        Header firstHeader = response.getFirstHeader("Request-ID");
        if (firstHeader == null) {
            throw WechatPay2Validator.parameterError("empty Request-ID", new Object[0]);
        }
        String requestId = firstHeader.getValue();
        String[] headers = new String[]{"Wechatpay-Serial", "Wechatpay-Signature", "Wechatpay-Nonce", "Wechatpay-Timestamp"};
        Header header = null;
        for (String headerName : headers) {
            header = response.getFirstHeader(headerName);
            if (header != null) continue;
            throw WechatPay2Validator.parameterError("empty [%s], request-id=[%s]", headerName, requestId);
        }
        String timestampStr = header.getValue();
        try {
            Instant responseTime = Instant.ofEpochSecond(Long.parseLong(timestampStr));
            if (Duration.between(responseTime, Instant.now()).abs().toMinutes() >= 5L) {
                throw WechatPay2Validator.parameterError("timestamp=[%s] expires, request-id=[%s]", timestampStr, requestId);
            }
        }
        catch (NumberFormatException | DateTimeException e) {
            throw WechatPay2Validator.parameterError("invalid timestamp=[%s], request-id=[%s]", timestampStr, requestId);
        }
    }

    protected final String buildMessage(CloseableHttpResponse response) throws IOException {
        String timestamp = response.getFirstHeader("Wechatpay-Timestamp").getValue();
        String nonce = response.getFirstHeader("Wechatpay-Nonce").getValue();
        String body = this.getResponseBody(response);
        return timestamp + "\n" + nonce + "\n" + body + "\n";
    }

    protected final String getResponseBody(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        return entity != null && entity.isRepeatable() ? EntityUtils.toString((HttpEntity)entity) : "";
    }
}

