/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.common.base.Objects;
import com.google.inject.grapher.Edge;
import com.google.inject.grapher.NodeId;

public class BindingEdge
extends Edge {
    private final Type type;

    public BindingEdge(NodeId fromId, NodeId toId, Type type) {
        super(fromId, toId);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BindingEdge)) {
            return false;
        }
        BindingEdge other = (BindingEdge)obj;
        return super.equals(other) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type));
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode((Object[])new Object[]{this.type});
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.getFromId()));
        String string2 = String.valueOf(String.valueOf(this.getToId()));
        String string3 = String.valueOf(String.valueOf((Object)this.type));
        return new StringBuilder(32 + string.length() + string2.length() + string3.length()).append("BindingEdge{fromId=").append(string).append(" toId=").append(string2).append(" type=").append(string3).append("}").toString();
    }

    @Override
    public Edge copy(NodeId fromId, NodeId toId) {
        return new BindingEdge(fromId, toId, this.type);
    }

    public static enum Type {
        NORMAL,
        PROVIDER,
        CONVERTED_CONSTANT;

    }
}

