/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.cmap;

import com.itextpdf.io.font.cmap.AbstractCMap;
import com.itextpdf.io.font.cmap.CMapObject;
import com.itextpdf.io.util.IntHashtable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMapCidToCodepoint
extends AbstractCMap {
    private static final byte[] EMPTY = new byte[0];
    private final Map<Integer, byte[]> map = new HashMap<Integer, byte[]>();
    private final List<byte[]> codeSpaceRanges = new ArrayList<byte[]>();

    @Override
    void addChar(String mark, CMapObject code) {
        if (code.isNumber()) {
            byte[] ser = CMapCidToCodepoint.decodeStringToByte(mark);
            this.map.put((int)((Integer)code.getValue()), ser);
        }
    }

    public byte[] lookup(int cid) {
        byte[] ser = this.map.get(cid);
        if (ser == null) {
            return EMPTY;
        }
        return ser;
    }

    public IntHashtable getReversMap() {
        IntHashtable code2cid = new IntHashtable(this.map.size());
        for (Map.Entry<Integer, byte[]> entry : this.map.entrySet()) {
            byte[] bytes = entry.getValue();
            int byteCode = 0;
            for (byte b : bytes) {
                byteCode <<= 8;
                byteCode += b & 0xFF;
            }
            code2cid.put(byteCode, entry.getKey());
        }
        return code2cid;
    }

    public List<byte[]> getCodeSpaceRanges() {
        return this.codeSpaceRanges;
    }

    @Override
    void addCodeSpaceRange(byte[] low, byte[] high) {
        this.codeSpaceRanges.add(low);
        this.codeSpaceRanges.add(high);
    }
}

