/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.signatures.CertificateInfo;
import com.itextpdf.signatures.SignUtils;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;

public class PdfSignatureAppearance {
    private static final float TOP_SECTION = 0.3f;
    private static final float MARGIN = 2.0f;
    private PdfDocument document;
    private int page = 1;
    private Rectangle rect;
    private Rectangle pageRect;
    private PdfFormXObject n0;
    private PdfFormXObject n2;
    private PdfFormXObject topLayer;
    private RenderingMode renderingMode = RenderingMode.DESCRIPTION;
    private String reason = "";
    private String reasonCaption = "Reason: ";
    private String location = "";
    private String locationCaption = "Location: ";
    private String signatureCreator = "";
    private String contact = "";
    private Calendar signDate;
    private Certificate signCertificate;
    private ImageData signatureGraphic = null;
    private ImageData image;
    private float imageScale;
    private String layer2Text;
    private PdfFont layer2Font;
    private float layer2FontSize = 0.0f;
    private Color layer2FontColor;
    private String fieldName;
    private boolean reuseAppearance = false;

    protected PdfSignatureAppearance(PdfDocument document, Rectangle pageRect, int pageNumber) {
        this.document = document;
        this.pageRect = new Rectangle(pageRect);
        this.rect = new Rectangle(pageRect.getWidth(), pageRect.getHeight());
        this.page = pageNumber;
    }

    public int getPageNumber() {
        return this.page;
    }

    public PdfSignatureAppearance setPageNumber(int pageNumber) {
        this.page = pageNumber;
        this.setPageRect(this.pageRect);
        return this;
    }

    public Rectangle getPageRect() {
        return this.pageRect;
    }

    public PdfSignatureAppearance setPageRect(Rectangle pageRect) {
        this.pageRect = new Rectangle(pageRect);
        this.rect = new Rectangle(pageRect.getWidth(), pageRect.getHeight());
        return this;
    }

    public PdfFormXObject getLayer0() {
        if (this.n0 == null) {
            this.n0 = new PdfFormXObject(this.rect);
            this.n0.makeIndirect(this.document);
        }
        return this.n0;
    }

    public PdfFormXObject getLayer2() {
        if (this.n2 == null) {
            this.n2 = new PdfFormXObject(this.rect);
            this.n2.makeIndirect(this.document);
        }
        return this.n2;
    }

    public RenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public PdfSignatureAppearance setRenderingMode(RenderingMode renderingMode) {
        this.renderingMode = renderingMode;
        return this;
    }

    public String getReason() {
        return this.reason;
    }

    public PdfSignatureAppearance setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public PdfSignatureAppearance setReasonCaption(String reasonCaption) {
        this.reasonCaption = reasonCaption;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public PdfSignatureAppearance setLocation(String location) {
        this.location = location;
        return this;
    }

    public PdfSignatureAppearance setLocationCaption(String locationCaption) {
        this.locationCaption = locationCaption;
        return this;
    }

    public String getSignatureCreator() {
        return this.signatureCreator;
    }

    public PdfSignatureAppearance setSignatureCreator(String signatureCreator) {
        this.signatureCreator = signatureCreator;
        return this;
    }

    public String getContact() {
        return this.contact;
    }

    public PdfSignatureAppearance setContact(String contact) {
        this.contact = contact;
        return this;
    }

    public PdfSignatureAppearance setCertificate(Certificate signCertificate) {
        this.signCertificate = signCertificate;
        return this;
    }

    public Certificate getCertificate() {
        return this.signCertificate;
    }

    public ImageData getSignatureGraphic() {
        return this.signatureGraphic;
    }

    public PdfSignatureAppearance setSignatureGraphic(ImageData signatureGraphic) {
        this.signatureGraphic = signatureGraphic;
        return this;
    }

    public PdfSignatureAppearance setReuseAppearance(boolean reuseAppearance) {
        this.reuseAppearance = reuseAppearance;
        return this;
    }

    public ImageData getImage() {
        return this.image;
    }

    public PdfSignatureAppearance setImage(ImageData image) {
        this.image = image;
        return this;
    }

    public float getImageScale() {
        return this.imageScale;
    }

    public PdfSignatureAppearance setImageScale(float imageScale) {
        this.imageScale = imageScale;
        return this;
    }

    public PdfSignatureAppearance setLayer2Text(String text) {
        this.layer2Text = text;
        return this;
    }

    public String getLayer2Text() {
        return this.layer2Text;
    }

    public PdfFont getLayer2Font() {
        return this.layer2Font;
    }

    public PdfSignatureAppearance setLayer2Font(PdfFont layer2Font) {
        this.layer2Font = layer2Font;
        return this;
    }

    public PdfSignatureAppearance setLayer2FontSize(float fontSize) {
        this.layer2FontSize = fontSize;
        return this;
    }

    public float getLayer2FontSize() {
        return this.layer2FontSize;
    }

    public PdfSignatureAppearance setLayer2FontColor(Color color) {
        this.layer2FontColor = color;
        return this;
    }

    public Color getLayer2FontColor() {
        return this.layer2FontColor;
    }

    public boolean isInvisible() {
        return this.rect == null || this.rect.getWidth() == 0.0f || this.rect.getHeight() == 0.0f;
    }

    protected PdfFormXObject getAppearance() throws IOException {
        PdfCanvas canvas;
        if (this.isInvisible()) {
            PdfFormXObject appearance = new PdfFormXObject(new Rectangle(0.0f, 0.0f));
            appearance.makeIndirect(this.document);
            return appearance;
        }
        if (this.n0 == null && !this.reuseAppearance) {
            this.createBlankN0();
        }
        if (this.n2 == null) {
            this.n2 = new PdfFormXObject(this.rect);
            this.n2.makeIndirect(this.document);
            canvas = new PdfCanvas(this.n2, this.document);
            int rotation = this.document.getPage(this.page).getRotation();
            if (rotation == 90) {
                canvas.concatMatrix(0.0, 1.0, -1.0, 0.0, (double)this.rect.getWidth(), 0.0);
            } else if (rotation == 180) {
                canvas.concatMatrix(-1.0, 0.0, 0.0, -1.0, (double)this.rect.getWidth(), (double)this.rect.getHeight());
            } else if (rotation == 270) {
                canvas.concatMatrix(0.0, -1.0, 1.0, 0.0, 0.0, (double)this.rect.getHeight());
            }
            Rectangle rotatedRect = PdfSignatureAppearance.rotateRectangle(this.rect, this.document.getPage(this.page).getRotation());
            String text = this.layer2Text;
            if (null == text) {
                text = this.generateLayer2Text();
            }
            if (this.image != null) {
                if (this.imageScale == 0.0f) {
                    canvas = new PdfCanvas(this.n2, this.document);
                    canvas.addImageWithTransformationMatrix(this.image, rotatedRect.getWidth(), 0.0f, 0.0f, rotatedRect.getHeight(), 0.0f, 0.0f);
                } else {
                    float usableScale = this.imageScale;
                    if (this.imageScale < 0.0f) {
                        usableScale = Math.min(rotatedRect.getWidth() / this.image.getWidth(), rotatedRect.getHeight() / this.image.getHeight());
                    }
                    float w = this.image.getWidth() * usableScale;
                    float h = this.image.getHeight() * usableScale;
                    float x = (rotatedRect.getWidth() - w) / 2.0f;
                    float y = (rotatedRect.getHeight() - h) / 2.0f;
                    canvas = new PdfCanvas(this.n2, this.document);
                    canvas.addImageWithTransformationMatrix(this.image, w, 0.0f, 0.0f, h, x, y);
                }
            }
            PdfFont font = this.layer2Font == null ? PdfFontFactory.createFont() : this.layer2Font;
            Rectangle dataRect = null;
            Rectangle signatureRect = null;
            if (this.renderingMode == RenderingMode.NAME_AND_DESCRIPTION || this.renderingMode == RenderingMode.GRAPHIC_AND_DESCRIPTION && this.signatureGraphic != null) {
                if (rotatedRect.getHeight() > rotatedRect.getWidth()) {
                    signatureRect = new Rectangle(2.0f, rotatedRect.getHeight() / 2.0f, rotatedRect.getWidth() - 4.0f, rotatedRect.getHeight() / 2.0f);
                    dataRect = new Rectangle(2.0f, 2.0f, rotatedRect.getWidth() - 4.0f, rotatedRect.getHeight() / 2.0f - 4.0f);
                } else {
                    signatureRect = new Rectangle(2.0f, 2.0f, rotatedRect.getWidth() / 2.0f - 4.0f, rotatedRect.getHeight() - 4.0f);
                    dataRect = new Rectangle(rotatedRect.getWidth() / 2.0f + 1.0f, 2.0f, rotatedRect.getWidth() / 2.0f - 2.0f, rotatedRect.getHeight() - 4.0f);
                }
            } else if (this.renderingMode == RenderingMode.GRAPHIC) {
                if (this.signatureGraphic == null) {
                    throw new IllegalStateException("A signature image must be present when rendering mode is graphic. Use setSignatureGraphic()");
                }
                signatureRect = new Rectangle(2.0f, 2.0f, rotatedRect.getWidth() - 4.0f, rotatedRect.getHeight() - 4.0f);
            } else {
                dataRect = new Rectangle(2.0f, 2.0f, rotatedRect.getWidth() - 4.0f, rotatedRect.getHeight() * 0.7f - 4.0f);
            }
            switch (this.renderingMode) {
                case NAME_AND_DESCRIPTION: {
                    String signedBy = CertificateInfo.getSubjectFields((X509Certificate)this.signCertificate).getField("CN");
                    if (signedBy == null) {
                        signedBy = CertificateInfo.getSubjectFields((X509Certificate)this.signCertificate).getField("E");
                    }
                    if (signedBy == null) {
                        signedBy = "";
                    }
                    this.addTextToCanvas(signedBy, font, signatureRect);
                    break;
                }
                case GRAPHIC_AND_DESCRIPTION: {
                    float imgHeight;
                    if (this.signatureGraphic == null) {
                        throw new IllegalStateException("A signature image must be present when rendering mode is graphic and description. Use setSignatureGraphic()");
                    }
                    float imgWidth = this.signatureGraphic.getWidth();
                    if (imgWidth == 0.0f) {
                        imgWidth = signatureRect.getWidth();
                    }
                    if ((imgHeight = this.signatureGraphic.getHeight()) == 0.0f) {
                        imgHeight = signatureRect.getHeight();
                    }
                    float multiplierH = signatureRect.getWidth() / this.signatureGraphic.getWidth();
                    float multiplierW = signatureRect.getHeight() / this.signatureGraphic.getHeight();
                    float multiplier = Math.min(multiplierH, multiplierW);
                    float x = signatureRect.getRight() - (imgWidth *= multiplier);
                    float y = signatureRect.getBottom() + (signatureRect.getHeight() - (imgHeight *= multiplier)) / 2.0f;
                    canvas = new PdfCanvas(this.n2, this.document);
                    canvas.addImageWithTransformationMatrix(this.signatureGraphic, imgWidth, 0.0f, 0.0f, imgHeight, x, y);
                    break;
                }
                case GRAPHIC: {
                    float imgHeight;
                    float imgWidth = this.signatureGraphic.getWidth();
                    if (imgWidth == 0.0f) {
                        imgWidth = signatureRect.getWidth();
                    }
                    if ((imgHeight = this.signatureGraphic.getHeight()) == 0.0f) {
                        imgHeight = signatureRect.getHeight();
                    }
                    float multiplierH = signatureRect.getWidth() / this.signatureGraphic.getWidth();
                    float multiplierW = signatureRect.getHeight() / this.signatureGraphic.getHeight();
                    float multiplier = Math.min(multiplierH, multiplierW);
                    float x = signatureRect.getLeft() + (signatureRect.getWidth() - (imgWidth *= multiplier)) / 2.0f;
                    float y = signatureRect.getBottom() + (signatureRect.getHeight() - (imgHeight *= multiplier)) / 2.0f;
                    canvas = new PdfCanvas(this.n2, this.document);
                    canvas.addImageWithTransformationMatrix(this.signatureGraphic, imgWidth, 0.0f, 0.0f, imgHeight, x, y);
                }
            }
            if (this.renderingMode != RenderingMode.GRAPHIC) {
                this.addTextToCanvas(text, font, dataRect);
            }
        }
        Rectangle rotated = new Rectangle(this.rect);
        if (this.topLayer == null) {
            PdfCanvas canvas1;
            this.topLayer = new PdfFormXObject(rotated);
            this.topLayer.makeIndirect(this.document);
            if (this.reuseAppearance) {
                PdfAcroForm acroForm = PdfFormCreator.getAcroForm((PdfDocument)this.document, (boolean)true);
                PdfFormField field = acroForm.getField(this.fieldName);
                PdfStream stream = ((PdfWidgetAnnotation)field.getWidgets().get(0)).getAppearanceDictionary().getAsStream(PdfName.N);
                PdfFormXObject xobj = new PdfFormXObject(stream);
                if (stream != null) {
                    this.topLayer.getResources().addForm(xobj, new PdfName("n0"));
                    PdfCanvas canvas12 = new PdfCanvas(this.topLayer, this.document);
                    canvas12.addXObjectWithTransformationMatrix((PdfXObject)xobj, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                } else {
                    this.reuseAppearance = false;
                    if (this.n0 == null) {
                        this.createBlankN0();
                    }
                }
            }
            if (!this.reuseAppearance) {
                this.topLayer.getResources().addForm(this.n0, new PdfName("n0"));
                canvas1 = new PdfCanvas(this.topLayer, this.document);
                canvas1.addXObjectWithTransformationMatrix((PdfXObject)this.n0, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            this.topLayer.getResources().addForm(this.n2, new PdfName("n2"));
            canvas1 = new PdfCanvas(this.topLayer, this.document);
            canvas1.addXObjectWithTransformationMatrix((PdfXObject)this.n2, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        PdfFormXObject napp = new PdfFormXObject(rotated);
        napp.makeIndirect(this.document);
        napp.getResources().addForm(this.topLayer, new PdfName("FRM"));
        canvas = new PdfCanvas(napp, this.document);
        canvas.addXObjectAt((PdfXObject)this.topLayer, this.topLayer.getBBox().getAsNumber(0).floatValue(), this.topLayer.getBBox().getAsNumber(1).floatValue());
        return napp;
    }

    protected Calendar getSignDate() {
        return this.signDate;
    }

    protected PdfSignatureAppearance setSignDate(Calendar signDate) {
        this.signDate = signDate;
        return this;
    }

    protected PdfSignatureAppearance setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    private static Rectangle rotateRectangle(Rectangle rect, int angle) {
        if (0 == angle / 90 % 2) {
            return new Rectangle(rect.getWidth(), rect.getHeight());
        }
        return new Rectangle(rect.getHeight(), rect.getWidth());
    }

    private void createBlankN0() {
        this.n0 = new PdfFormXObject(new Rectangle(100.0f, 100.0f));
        this.n0.makeIndirect(this.document);
        PdfCanvas canvas = new PdfCanvas(this.n0, this.document);
        canvas.writeLiteral("% DSBlank\n");
    }

    private void addTextToCanvas(String text, PdfFont font, Rectangle dataRect) {
        PdfCanvas canvas = new PdfCanvas(this.n2, this.document);
        Paragraph paragraph = ((Paragraph)((Paragraph)new Paragraph(text).setFont(font)).setMargin(0.0f)).setMultipliedLeading(0.9f);
        Canvas layoutCanvas = new Canvas(canvas, dataRect);
        paragraph.setFontColor(this.layer2FontColor);
        if (this.layer2FontSize == 0.0f) {
            this.applyCopyFittingFontSize(paragraph, dataRect, (IRenderer)layoutCanvas.getRenderer());
        } else {
            paragraph.setFontSize(this.layer2FontSize);
        }
        layoutCanvas.add((IBlockElement)paragraph);
    }

    private void applyCopyFittingFontSize(Paragraph paragraph, Rectangle rect, IRenderer parentRenderer) {
        IRenderer renderer = paragraph.createRendererSubTree().setParent(parentRenderer);
        LayoutContext layoutContext = new LayoutContext(new LayoutArea(1, rect));
        float lFontSize = 0.1f;
        float rFontSize = 100.0f;
        int numberOfIterations = 15;
        for (int i = 0; i < numberOfIterations; ++i) {
            float mFontSize = (lFontSize + rFontSize) / 2.0f;
            paragraph.setFontSize(mFontSize);
            LayoutResult result = renderer.layout(layoutContext);
            if (result.getStatus() == 1) {
                lFontSize = mFontSize;
                continue;
            }
            rFontSize = mFontSize;
        }
        paragraph.setFontSize(lFontSize);
    }

    String generateLayer2Text() {
        StringBuilder buf = new StringBuilder();
        buf.append("Digitally signed by ");
        String name = null;
        CertificateInfo.X500Name x500name = CertificateInfo.getSubjectFields((X509Certificate)this.signCertificate);
        if (x500name != null && (name = x500name.getField("CN")) == null) {
            name = x500name.getField("E");
        }
        if (name == null) {
            name = "";
        }
        buf.append(name).append('\n');
        buf.append("Date: ").append(SignUtils.dateToString(this.signDate));
        if (this.reason != null) {
            buf.append('\n').append(this.reasonCaption).append(this.reason);
        }
        if (this.location != null) {
            buf.append('\n').append(this.locationCaption).append(this.location);
        }
        return buf.toString();
    }

    public static enum RenderingMode {
        DESCRIPTION,
        NAME_AND_DESCRIPTION,
        GRAPHIC_AND_DESCRIPTION,
        GRAPHIC;

    }
}

