/*
 * Decompiled with CFR 0.152.
 */
package com.liumapp.qtools.date;

import com.liumapp.qtools.date.DateType;
import com.liumapp.qtools.date.Lunar;
import com.liumapp.qtools.date.Solar;
import com.liumapp.qtools.date.ToolDatePlus;
import com.liumapp.qtools.date.ToolLunar;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;

public class DatePlus
implements Serializable,
Cloneable {
    private LocalDateTime localDateTime;
    private static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = ToolDatePlus.pattern("yyyy-MM-dd HH:mm:ss:SSS");
    private static final String[] CHINESE_ZODIAC = new String[]{"\u7334", "\u9e21", "\u72d7", "\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a"};
    private static final String[] ZODIAC = new String[]{"\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u9b54\u7faf\u5ea7"};
    private static final int[] ZODIAC_FLAGS = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 24, 23, 22};

    public DatePlus() {
        this.localDateTime = LocalDateTime.now();
    }

    public DatePlus(LocalDateTime localDateTime) {
        this.localDateTime = LocalDateTime.of(localDateTime.toLocalDate(), localDateTime.toLocalTime());
    }

    public DatePlus(int year, int month, int dayOfMonth) {
        this.localDateTime = LocalDateTime.of(LocalDate.of(year, month, dayOfMonth), LocalTime.MIN);
    }

    public DatePlus(int hour, int minutes) {
        this.localDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.of(hour, minutes));
    }

    public DatePlus(int year, int month, int dayOfMonth, int hour, int minutes) {
        this.localDateTime = LocalDateTime.of(year, month, dayOfMonth, hour, minutes);
    }

    public DatePlus(int year, int month, int dayOfMonth, int hour, int minutes, int seconds) {
        this.localDateTime = LocalDateTime.of(year, month, dayOfMonth, hour, minutes, seconds);
    }

    public DatePlus(int year, int month, int dayOfMonth, int hour, int minutes, int seconds, int nanoOfSecond) {
        this.localDateTime = LocalDateTime.of(year, month, dayOfMonth, hour, minutes, seconds, nanoOfSecond);
    }

    public DatePlus(long time) {
        this.localDateTime = ToolDatePlus.time2LocalDateTime(time);
    }

    public DatePlus(Date date) {
        this.localDateTime = ToolDatePlus.date2LocalDateTime(date);
    }

    public DatePlus(String dateStr, String pattern) {
        try {
            this.localDateTime = LocalDateTime.parse(dateStr, ToolDatePlus.pattern(pattern));
        }
        catch (DateTimeParseException e) {
            LocalDate date = LocalDate.parse(dateStr, ToolDatePlus.pattern(pattern));
            LocalTime time = LocalTime.MIN;
            this.localDateTime = LocalDateTime.of(date, time);
        }
    }

    public DatePlus(String dateStr, DateTimeFormatter dateTimeFormatter) {
        try {
            this.localDateTime = LocalDateTime.parse(dateStr, dateTimeFormatter);
        }
        catch (DateTimeParseException e) {
            LocalDate date = LocalDate.parse(dateStr, dateTimeFormatter);
            LocalTime time = LocalTime.MIN;
            this.localDateTime = LocalDateTime.of(date, time);
        }
    }

    public DatePlus addYear(long year) {
        this.localDateTime = this.localDateTime.plusYears(year);
        return this;
    }

    public DatePlus addMonth(long month) {
        this.localDateTime = this.localDateTime.plusMonths(month);
        return this;
    }

    public DatePlus addWeek(long week) {
        this.localDateTime = this.localDateTime.plusWeeks(week);
        return this;
    }

    public DatePlus addDay(long dayOfMonth) {
        this.localDateTime = this.localDateTime.plusDays(dayOfMonth);
        return this;
    }

    public DatePlus addHour(long hour) {
        this.localDateTime = this.localDateTime.plusHours(hour);
        return this;
    }

    public DatePlus addMinutes(long minutes) {
        this.localDateTime = this.localDateTime.plusMinutes(minutes);
        return this;
    }

    public DatePlus addSeconds(long seconds) {
        this.localDateTime = this.localDateTime.plusSeconds(seconds);
        return this;
    }

    public DatePlus addNano(long nanoSeconds) {
        this.localDateTime = this.localDateTime.plusNanos(nanoSeconds);
        return this;
    }

    public int getYear() {
        return this.localDateTime.getYear();
    }

    public int getMonth() {
        return this.localDateTime.getMonthValue();
    }

    public Month getMonthObj() {
        return this.localDateTime.getMonth();
    }

    public int getDayOfWeek() {
        return this.localDateTime.getDayOfWeek().getValue();
    }

    public DayOfWeek getDayOfWeekObj() {
        return this.localDateTime.getDayOfWeek();
    }

    public int getDayOfMonth() {
        return this.localDateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.localDateTime.getDayOfYear();
    }

    public int getHour() {
        return this.localDateTime.getHour();
    }

    public int getMinute() {
        return this.localDateTime.getMinute();
    }

    public int getSecond() {
        return this.localDateTime.getSecond();
    }

    public int getNanoSecond() {
        return this.localDateTime.getNano();
    }

    public DatePlus getLastDayOfMonth() {
        return new DatePlus(this.localDateTime.with(TemporalAdjusters.lastDayOfMonth()));
    }

    public DatePlus getLastDayOfYear() {
        return new DatePlus(this.localDateTime.with(TemporalAdjusters.lastDayOfYear()));
    }

    public DatePlus getFirstDayOfMonth() {
        return new DatePlus(this.localDateTime.with(TemporalAdjusters.firstDayOfMonth()));
    }

    public DatePlus getFirstDayOfYear() {
        return new DatePlus(this.localDateTime.with(TemporalAdjusters.firstDayOfYear()));
    }

    public DatePlus getFirstDayOfNextMonth() {
        return new DatePlus(this.localDateTime.with(TemporalAdjusters.firstDayOfNextMonth()));
    }

    public DatePlus getFirstDayOfNextYear() {
        return new DatePlus(this.localDateTime.with(TemporalAdjusters.firstDayOfNextYear()));
    }

    public boolean isLeapYear() {
        return this.localDateTime.toLocalDate().isLeapYear();
    }

    public boolean isBefore(DatePlus datePlus, DateType dateType) {
        boolean isBefore;
        switch (dateType) {
            case YEAR: {
                isBefore = this.ofYear(datePlus) < 0L;
                break;
            }
            case MONTH: {
                isBefore = this.ofMonth(datePlus) < 0L;
                break;
            }
            case DAY: {
                isBefore = this.ofDay(datePlus) < 0L;
                break;
            }
            case HOUR: {
                isBefore = this.ofHour(datePlus) < 0L;
                break;
            }
            case MINUTES: {
                isBefore = this.ofMinutes(datePlus) < 0L;
                break;
            }
            case SECONDS: {
                isBefore = this.ofSeconds(datePlus) < 0L;
                break;
            }
            default: {
                isBefore = this.ofSeconds(datePlus) < 0L;
            }
        }
        return isBefore;
    }

    public boolean isSame(DatePlus datePlus, DateType dateType) {
        boolean isSame;
        switch (dateType) {
            case YEAR: {
                isSame = this.ofYear(datePlus) == 0L;
                break;
            }
            case MONTH: {
                isSame = this.ofMonth(datePlus) == 0L;
                break;
            }
            case DAY: {
                isSame = this.ofDay(datePlus) == 0L;
                break;
            }
            case HOUR: {
                isSame = this.ofHour(datePlus) == 0L;
                break;
            }
            case MINUTES: {
                isSame = this.ofMinutes(datePlus) == 0L;
                break;
            }
            case SECONDS: {
                isSame = this.ofSeconds(datePlus) == 0L;
                break;
            }
            default: {
                isSame = this.ofSeconds(datePlus) == 0L;
            }
        }
        return isSame;
    }

    public boolean isAfter(DatePlus datePlus, DateType dateType) {
        boolean isAfter;
        switch (dateType) {
            case YEAR: {
                isAfter = this.ofYear(datePlus) > 0L;
                break;
            }
            case MONTH: {
                isAfter = this.ofMonth(datePlus) > 0L;
                break;
            }
            case DAY: {
                isAfter = this.ofDay(datePlus) > 0L;
                break;
            }
            case HOUR: {
                isAfter = this.ofHour(datePlus) > 0L;
                break;
            }
            case MINUTES: {
                isAfter = this.ofMinutes(datePlus) > 0L;
                break;
            }
            case SECONDS: {
                isAfter = this.ofSeconds(datePlus) > 0L;
                break;
            }
            default: {
                isAfter = this.ofSeconds(datePlus) > 0L;
            }
        }
        return isAfter;
    }

    public long ofYear(DatePlus datePlus) {
        return this.ofDateTime(ChronoUnit.YEARS, datePlus);
    }

    public long ofMonth(DatePlus datePlus) {
        return this.ofDateTime(ChronoUnit.MONTHS, datePlus);
    }

    public long ofDay(DatePlus datePlus) {
        return this.ofDateTime(ChronoUnit.DAYS, datePlus);
    }

    public long ofHour(DatePlus datePlus) {
        return this.ofDateTime(ChronoUnit.HOURS, datePlus);
    }

    public long ofMinutes(DatePlus datePlus) {
        return this.ofDateTime(ChronoUnit.MINUTES, datePlus);
    }

    public long ofSeconds(DatePlus datePlus) {
        return this.ofDateTime(ChronoUnit.SECONDS, datePlus);
    }

    public long ofNanos(DatePlus datePlus) {
        return this.ofDateTime(ChronoUnit.NANOS, datePlus);
    }

    public long ofDateTime(ChronoUnit chronoUnit, DatePlus datePlus) {
        return -chronoUnit.between(this.localDateTime, datePlus.localDateTime);
    }

    public LocalDateTime getLocalDateTime() {
        return this.localDateTime;
    }

    public DatePlus toMinDate(DateType dateType) {
        switch (dateType) {
            case YEAR: {
                this.localDateTime = LocalDateTime.of(this.getYear(), 1, 1, 0, 0, 0, 0);
                break;
            }
            case MONTH: {
                this.localDateTime = LocalDateTime.of(this.getYear(), this.getMonth(), 1, 0, 0, 0, 0);
                break;
            }
            case DAY: {
                this.localDateTime = LocalDateTime.of(this.getYear(), this.getMonth(), this.getDayOfMonth(), 0, 0, 0, 0);
                break;
            }
            case HOUR: {
                this.localDateTime = LocalDateTime.of(this.getYear(), this.getMonth(), this.getDayOfMonth(), this.getHour(), 0, 0, 0);
                break;
            }
            case MINUTES: {
                this.localDateTime = LocalDateTime.of(this.getYear(), this.getMonth(), this.getDayOfMonth(), this.getHour(), this.getMinute(), 0, 0);
                break;
            }
            case SECONDS: {
                this.localDateTime = LocalDateTime.of(this.getYear(), this.getMonth(), this.getDayOfMonth(), this.getHour(), this.getMinute(), this.getSecond(), 0);
                break;
            }
        }
        return this;
    }

    public DatePlus toMaxDate(DateType dateType) {
        switch (dateType) {
            case YEAR: {
                this.localDateTime = LocalDateTime.of(this.getYear(), 12, 31, 23, 59, 59, 999999999);
                break;
            }
            case MONTH: {
                this.localDateTime = LocalDateTime.of(this.getYear(), this.getMonth(), this.getLastDayOfMonth().getDayOfMonth(), 23, 59, 59, 999999999);
                break;
            }
            case DAY: {
                this.localDateTime = LocalDateTime.of(this.getYear(), this.getMonth(), this.getDayOfMonth(), 23, 59, 59, 999999999);
                break;
            }
            case HOUR: {
                this.localDateTime = LocalDateTime.of(this.getYear(), this.getMonth(), this.getDayOfMonth(), this.getHour(), 59, 59, 999999999);
                break;
            }
            case MINUTES: {
                this.localDateTime = LocalDateTime.of(this.getYear(), this.getMonth(), this.getDayOfMonth(), this.getHour(), this.getMinute(), 59, 999999999);
                break;
            }
            case SECONDS: {
                this.localDateTime = LocalDateTime.of(this.getYear(), this.getMonth(), this.getDayOfMonth(), this.getHour(), this.getMinute(), this.getSecond(), 999999999);
                break;
            }
        }
        return this;
    }

    public Date toDate() {
        return ToolDatePlus.localDateTime2Date(this.localDateTime);
    }

    public String toGanZhi() {
        return ToolLunar.lunarYearToGanZhi(this.toLunar().getLunarYear());
    }

    public String toZodiac() {
        int month = this.getMonth();
        int day = this.getDayOfMonth();
        return ZODIAC[day >= ZODIAC_FLAGS[month - 1] ? month - 1 : (month + 10) % 12];
    }

    public String toChineseZodiac() {
        return CHINESE_ZODIAC[this.getYear() % 12];
    }

    public Lunar toLunar() {
        Solar solar = new Solar(this.getYear(), this.getMonth(), this.getDayOfMonth());
        return ToolLunar.solartolunar(solar);
    }

    public Solar toSolar() {
        Lunar lunar = new Lunar(this.getYear(), this.getMonth(), this.getDayOfMonth());
        return ToolLunar.lunartosolar(lunar);
    }

    public String toString(DateTimeFormatter formatter) {
        return this.localDateTime.format(formatter);
    }

    public String toString(String pattern) {
        return this.localDateTime.format(ToolDatePlus.pattern(pattern));
    }

    public String toString() {
        return this.toString(DEFAULT_DATE_TIME_FORMATTER);
    }

    public boolean equals(Object object) {
        return this.localDateTime.equals(object);
    }

    public int hashCode() {
        return this.localDateTime.hashCode();
    }

    public DatePlus clone() {
        return new DatePlus(this.localDateTime);
    }
}

