/*
 * Copyright 2018 mayabot.com authors. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mayabot.nlp.segment.analyzer;

import com.google.common.collect.AbstractIterator;
import com.mayabot.nlp.segment.WordTerm;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class WordTermGeneratorIterable implements Iterable<WordTerm> {

    WordTermGenerator generator;

    public WordTermGeneratorIterable(WordTermGenerator generator) {
        this.generator = generator;
    }

    @Override
    public Iterator<WordTerm> iterator() {
        return new AbstractIterator<WordTerm>() {
            @Override
            protected WordTerm computeNext() {
                WordTerm word = generator.nextWord();
                if (word == null) {
                    return endOfData();
                } else {
                    return word;
                }
            }
        };
    }

    public Stream<WordTerm> stream() {
        return StreamSupport.stream(spliterator(), false);
    }
}