/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp;

import com.mayabot.nlp.Mynlp;
import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.Mynlps;
import com.mayabot.nlp.SettingItem;
import com.mayabot.nlp.Settings;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.resources.ClasspathNlpResourceFactory;
import com.mayabot.nlp.resources.FileNlpResourceFactory;
import com.mayabot.nlp.resources.JarNlpResourceFactory;
import com.mayabot.nlp.resources.NlpResourceFactory;
import com.mayabot.nlp.utils.MynlpFactories;
import com.mayabot.t.google.common.base.Preconditions;
import com.mayabot.t.google.common.collect.ImmutableList;
import com.mayabot.t.google.common.collect.Lists;
import com.mayabot.t.google.common.collect.Maps;
import com.mayabot.t.google.inject.AbstractModule;
import com.mayabot.t.google.inject.Guice;
import com.mayabot.t.google.inject.Injector;
import com.mayabot.t.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MynlpBuilder {
    public static InternalLogger logger = InternalLoggerFactory.getInstance("com.mayabot.nlp.Mynlps");
    private String dataDir;
    private String cacheDir;
    private ArrayList<NlpResourceFactory> resourceFactoryList = Lists.newArrayList();
    private Settings settings = Settings.defaultSystemSettings();
    private Map<Class, Object> injectInstance = Maps.newHashMap();

    Mynlp build() throws RuntimeException {
        try {
            File dataDirFile;
            logger.info("Current Working Dir is " + new File(".").getAbsolutePath());
            if (this.dataDir == null && System.getProperty("mynlp.data.dir") != null) {
                this.dataDir = System.getProperty("mynlp.data.dir");
            }
            if (this.dataDir == null) {
                this.dataDir = this.settings.get("data.dir", null);
            }
            if (this.dataDir == null) {
                this.dataDir = System.getProperty("user.home") + "/.mynlp.data";
            }
            if (!(dataDirFile = new File(this.dataDir)).exists()) {
                dataDirFile.mkdir();
            }
            logger.info("Mynlp data dir is " + dataDirFile.getAbsolutePath() + ",exists " + dataDirFile.exists());
            if (this.settings.get("cache.dir") != null) {
                this.cacheDir = this.settings.get("cache.dir");
            }
            File cacheDirFile = this.cacheDir == null ? this.ensureDir(new File(dataDirFile, "caches")) : this.ensureDir(new File(this.cacheDir));
            logger.info("Mynlp cache dir is {}", (Object)cacheDirFile.getAbsolutePath());
            this.resourceFactoryList.add(new FileNlpResourceFactory(dataDirFile));
            this.resourceFactoryList.add(new JarNlpResourceFactory(dataDirFile));
            this.resourceFactoryList.add(new ClasspathNlpResourceFactory(Mynlps.class.getClassLoader()));
            ImmutableList.copyOf(this.resourceFactoryList);
            MynlpEnv env = new MynlpEnv(dataDirFile, cacheDirFile, this.resourceFactoryList, this.settings);
            Injector injector = this.createInject(env);
            return new Mynlp(env, injector);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Injector createInject(final MynlpEnv mynlpEnv) {
        ArrayList<Module> modules = Lists.newArrayList();
        modules.add(new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(MynlpEnv.class).toInstance(mynlpEnv);
                MynlpBuilder.this.injectInstance.forEach((k, v) -> this.bind(k).toInstance(v));
            }
        });
        modules.addAll(this.loadModules(mynlpEnv));
        return Guice.createInjector(modules);
    }

    private List<Module> loadModules(MynlpEnv mynlp) {
        try {
            Collection<Class> classes = MynlpFactories.load().get("GuiceModule");
            return classes.stream().map(clazz -> {
                try {
                    try {
                        Constructor c1 = clazz.getConstructor(MynlpEnv.class);
                        if (c1 != null) {
                            return (Module)c1.newInstance(mynlp);
                        }
                    }
                    catch (NoSuchMethodException c1) {
                        // empty catch block
                    }
                    return (Module)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addResourceFactory(NlpResourceFactory resourceFactory) {
        this.resourceFactoryList.add(resourceFactory);
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public MynlpBuilder setDataDir(String dataDir) {
        this.dataDir = dataDir;
        return this;
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    public MynlpBuilder setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
        return this;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public MynlpBuilder set(String key, String value) {
        this.getSettings().put(key, value);
        return this;
    }

    public MynlpBuilder set(SettingItem key, String value) {
        this.getSettings().put(key, value);
        return this;
    }

    public MynlpBuilder setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public <T> MynlpBuilder bind(Class<T> clazz, T object) {
        this.injectInstance.put(clazz, object);
        return this;
    }

    private File ensureDir(File file) throws IOException {
        if (!file.exists()) {
            this.createParentDirs(file);
            file.mkdir();
        }
        if (!file.isDirectory()) {
            throw new IOException(file + " is not dir");
        }
        return file;
    }

    private void createParentDirs(File file) throws IOException {
        Preconditions.checkNotNull(file);
        File parent = file.getCanonicalFile().getParentFile();
        if (parent == null) {
            return;
        }
        parent.mkdirs();
        if (!parent.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file);
        }
    }
}

