/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp;

import com.mayabot.nlp.Mynlps;
import com.mayabot.nlp.ResoucesMissing;
import com.mayabot.nlp.SettingItem;
import com.mayabot.nlp.Settings;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.resources.ClasspathNlpResourceFactory;
import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.nlp.resources.NlpResourceFactory;
import com.mayabot.t.google.common.base.Charsets;
import com.mayabot.t.google.common.collect.ImmutableList;
import com.mayabot.t.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MynlpEnv {
    public static InternalLogger logger = InternalLoggerFactory.getInstance(MynlpEnv.class);
    private File dataDir;
    private File cacheDir;
    private List<NlpResourceFactory> resourceFactory;
    private Settings settings;
    private Map<String, ResoucesMissing> missingList = new ConcurrentHashMap<String, ResoucesMissing>();
    private String downloadBaseUrl = "http://cdn.mayabot.com/mynlp/files/";

    public MynlpEnv(File dataDir, File cacheDir, List<NlpResourceFactory> resourceFactory, Settings settings) {
        this.dataDir = dataDir;
        this.cacheDir = cacheDir;
        this.resourceFactory = ImmutableList.copyOf(resourceFactory);
        this.settings = settings;
    }

    public MynlpEnv() {
        this.resourceFactory = ImmutableList.of(new ClasspathNlpResourceFactory(Mynlps.class.getClassLoader()));
        this.settings = Settings.defaultSystemSettings();
    }

    public void registeResourceMissing(String name, ResoucesMissing missing) {
        this.missingList.put(name, missing);
    }

    public void registeResourceMissing(String name, String rsName, String jarName, String version) {
        this.registeResourceMissing(name, (rsName2, env) -> {
            File file;
            return rsName.equals(rsName2) && (file = env.download(jarName.replace(".jar", "-" + version + ".jar"))) != null && file.exists();
        });
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void set(String key, String value) {
        this.settings.put(key, value);
    }

    public String hashResource(String resourceName) {
        NlpResource r1 = this.loadResource(resourceName, Charsets.UTF_8);
        if (r1 != null) {
            return r1.hash();
        }
        return null;
    }

    public synchronized NlpResource loadResource(String resourceName, Charset charset) {
        return AccessController.doPrivileged(() -> {
            if (resourceName == null || resourceName.trim().isEmpty()) {
                return null;
            }
            NlpResource resource = this.getNlpResource(resourceName, charset);
            boolean ps = false;
            if (resource == null) {
                for (ResoucesMissing missing : this.missingList.values()) {
                    boolean r = missing.process(resourceName, this);
                    if (!r) continue;
                    ps = true;
                    break;
                }
            }
            if (ps) {
                resource = this.getNlpResource(resourceName, charset);
            }
            return resource;
        });
    }

    private NlpResource getNlpResource(String resourceName, Charset charset) {
        NlpResource resource = null;
        long t1 = System.currentTimeMillis();
        for (NlpResourceFactory factory : this.resourceFactory) {
            resource = factory.load(resourceName, charset);
            if (resource == null) continue;
            String string = resource.toString();
            if (string.length() >= 100) {
                string = "../.." + string.substring(string.length() - 60);
            }
            long t2 = System.currentTimeMillis();
            logger.info("load resource {} ,use time {} ms", (Object)string, (Object)(t2 - t1));
            break;
        }
        return resource;
    }

    public synchronized NlpResource loadResource(String resourceName) {
        return this.loadResource(resourceName, Charsets.UTF_8);
    }

    public synchronized NlpResource loadResource(SettingItem<String> resourceNameSettting) {
        return this.loadResource(this.settings.get(resourceNameSettting), Charsets.UTF_8);
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public synchronized File download(String fileName) {
        return AccessController.doPrivileged(() -> {
            File file = new File(this.dataDir, fileName);
            if (file.exists()) {
                return file;
            }
            try {
                URL url = new URL(this.downloadBaseUrl + fileName);
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                System.out.println("Downloading " + url);
                connection.connect();
                try (BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
                     BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                    ByteStreams.copy(inputStream, out);
                }
                System.out.println("Downloaded " + fileName + " , save to " + file);
                if (file.exists()) {
                    return file;
                }
            }
            catch (Exception e) {
                System.err.println("Download " + this.downloadBaseUrl + fileName + " error!!!\n");
                e.printStackTrace();
                file.delete();
            }
            return null;
        });
    }
}

