/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp;

import com.mayabot.nlp.Mynlp;
import com.mayabot.nlp.MynlpBuilder;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public final class Mynlps {
    public static InternalLogger logger = InternalLoggerFactory.getInstance("com.mayabot.nlp.Mynlps");
    private static final ConcurrentHashMap<String, Mynlp> map = new ConcurrentHashMap();

    public static void install(Consumer<MynlpBuilder> consumer) {
        if (!map.isEmpty()) {
            throw new RuntimeException("Do install action before call get()!");
        }
        MynlpBuilder builder = new MynlpBuilder();
        consumer.accept(builder);
        map.put("I", builder.build());
    }

    public static void setDataDir(String dataDir) {
        AccessController.doPrivileged(() -> {
            System.setProperty("mynlp.data.dir", dataDir);
            return null;
        });
    }

    public static void clear() {
        map.clear();
    }

    public static Mynlp get() {
        return map.computeIfAbsent("I", Mynlps::create);
    }

    private static Mynlp create(String s) {
        return AccessController.doPrivileged(() -> new MynlpBuilder().build());
    }

    private Mynlps() {
    }

    public static <T> T instanceOf(Class<T> clazz) {
        return (T)AccessController.doPrivileged(() -> Mynlps.get().getInstance(clazz));
    }
}

