/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.algorithm;

import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToDoubleBiFunction;

public class SecondOrderViterbi<TagType, ObjType> {
    private final BiConsumer<ObjType, TagType> consumer;
    private final ToDoubleBiFunction scorer;
    private final Function<ObjType, Map<TagType, Integer>> mapFunction;

    public SecondOrderViterbi(ToDoubleBiFunction<Map.Entry<TagType, Integer>, Map.Entry<TagType, Integer>> scorer, Function<ObjType, Map<TagType, Integer>> mapFunction, BiConsumer<ObjType, TagType> consumer) {
        this.consumer = consumer;
        this.scorer = scorer;
        this.mapFunction = mapFunction;
    }

    public void viterbi(Iterable<ObjType> pathWithBE) {
        double[] row0 = new double[8];
        double[] row1 = new double[8];
        Iterator<ObjType> iterator = pathWithBE.iterator();
        ObjType begin = iterator.next();
        Map.Entry<TagType, Integer> firstSelect = this.mapFunction.apply(begin).entrySet().iterator().next();
        this.consumer.accept(begin, firstSelect.getKey());
        ObjType preObj = begin;
        ObjType the = iterator.next();
        Map<TagType, Integer> item = this.mapFunction.apply(the);
        int j = 0;
        if (item.size() > row0.length) {
            row0 = new double[item.size()];
        }
        for (Map.Entry<TagType, Integer> cur : item.entrySet()) {
            row0[j] = this.scorer.applyAsDouble(firstSelect, cur);
            ++j;
        }
        preObj = the;
        double[] theCost = row0;
        double[] preCost = row1;
        Object the2 = null;
        while (iterator.hasNext()) {
            the2 = iterator.next();
            double[] _t = theCost;
            theCost = preCost;
            preCost = _t;
            this.clear(theCost);
            Map<TagType, Integer> item2 = this.mapFunction.apply(the2);
            if (item2.size() > theCost.length) {
                theCost = new double[item2.size()];
            }
            double perfect_cost_line = Double.MAX_VALUE;
            Map.Entry<TagType, Integer> pre = null;
            int k = 0;
            for (Map.Entry<TagType, Integer> cur : item2.entrySet()) {
                theCost[k] = Double.MAX_VALUE;
                int j2 = 0;
                for (Map.Entry<TagType, Integer> p : this.mapFunction.apply(preObj).entrySet()) {
                    double now = preCost[j2] + this.scorer.applyAsDouble(p, cur);
                    if (now < theCost[k]) {
                        theCost[k] = now;
                        if (now < perfect_cost_line) {
                            perfect_cost_line = now;
                            pre = p;
                        }
                    }
                    ++j2;
                }
                ++k;
            }
            if (pre == null) {
                this.consumer.accept(preObj, null);
            } else {
                this.consumer.accept(preObj, pre.getKey());
            }
            preObj = the2;
        }
        this.consumer.accept(preObj, this.mapFunction.apply(preObj).keySet().iterator().next());
    }

    public void viterbi(ObjType[] array) {
        double[] row0 = new double[64];
        double[] row1 = new double[64];
        ObjType begin = array[0];
        Map.Entry<TagType, Integer> firstSelect = this.mapFunction.apply(begin).entrySet().iterator().next();
        this.consumer.accept(begin, firstSelect.getKey());
        int j = 0;
        for (Map.Entry<TagType, Integer> cur : this.mapFunction.apply(array[1]).entrySet()) {
            row0[j] = this.scorer.applyAsDouble(firstSelect, cur);
            ++j;
        }
        double[] theCost = row0;
        double[] preCost = row1;
        for (int i = 2; i < array.length; ++i) {
            double[] _t = theCost;
            theCost = preCost;
            preCost = _t;
            Map<TagType, Integer> item = this.mapFunction.apply(array[i]);
            this.clear(theCost);
            double perfect_cost_line = Double.MAX_VALUE;
            int k = 0;
            Map.Entry<TagType, Integer> pre = null;
            for (Map.Entry<TagType, Integer> cur : item.entrySet()) {
                theCost[k] = Double.MAX_VALUE;
                int j2 = 0;
                for (Map.Entry<TagType, Integer> p : this.mapFunction.apply(array[i - 1]).entrySet()) {
                    double now = preCost[j2] + this.scorer.applyAsDouble(p, cur);
                    if (now < theCost[k]) {
                        theCost[k] = now;
                        if (now < perfect_cost_line) {
                            perfect_cost_line = now;
                            pre = p;
                        }
                    }
                    ++j2;
                }
                ++k;
            }
            this.consumer.accept(array[i - 1], pre.getKey());
        }
        this.consumer.accept(array[array.length - 1], this.mapFunction.apply(array[array.length - 1]).keySet().iterator().next());
    }

    private void clear(double[] doubles) {
        for (int i = doubles.length - 1; i >= 0; --i) {
            doubles[i] = 0.0;
        }
    }
}

