/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.algorithm;

import com.mayabot.nlp.common.EnumFreqPair;
import com.mayabot.nlp.common.matrix.EnumTransformMatrix;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Viterbi {
    public static <E extends Enum<E>> List<E> computeEnumSimply(List<EnumFreqPair<E>> roleTagList, EnumTransformMatrix<E> transformMatrixDictionary) {
        E pre;
        int length = roleTagList.size() - 1;
        LinkedList<E> tagList = new LinkedList<E>();
        Iterator<EnumFreqPair<E>> iterator = roleTagList.iterator();
        EnumFreqPair<E> start = iterator.next();
        Object perfect_tag = pre = start.oneKey();
        tagList.add(pre);
        for (int i = 0; i < length; ++i) {
            double perfect_cost = Double.MAX_VALUE;
            EnumFreqPair<Enum> item = iterator.next();
            for (Enum cur : item.keySet()) {
                double now = (double)transformMatrixDictionary.getFrequency((Enum)pre, cur) - Math.log(((double)item.getFrequency(cur) + 1.0E-8) / (double)transformMatrixDictionary.getTotalFrequency(cur));
                if (!(perfect_cost > now)) continue;
                perfect_cost = now;
                perfect_tag = cur;
            }
            pre = perfect_tag;
            tagList.add(pre);
        }
        return tagList;
    }

    public static <Obj, E extends Enum<E>> void computeEnumSimply2(Obj[] roleTagList, ObjReadEnumFreqPair<Obj, E> map, EnumTransformMatrix<E> transformMatrixDictionary, ConfirmTag<Obj, E> processer) {
        E pre;
        Obj first = roleTagList[0];
        EnumFreqPair<E> start = map.read(first);
        Object perfect_tag = pre = start.oneKey();
        processer.confirm(first, pre);
        for (int i = 1; i < roleTagList.length; ++i) {
            double perfect_cost = Double.MAX_VALUE;
            Obj obj = roleTagList[i];
            EnumFreqPair<Enum> item = map.read(obj);
            for (Enum cur : item.keySet()) {
                double now = transformMatrixDictionary.getTP((Enum)pre, cur) - Math.log(((double)item.getFrequency(cur) + 1.0E-8) / (double)transformMatrixDictionary.getTotalFrequency(cur));
                if (!(perfect_cost > now)) continue;
                perfect_cost = now;
                perfect_tag = cur;
            }
            pre = perfect_tag;
            processer.confirm(obj, pre);
        }
    }

    public static interface ConfirmTag<Obj, E> {
        public void confirm(Obj var1, E var2);
    }

    public static interface ObjReadEnumFreqPair<Obj, E extends Enum<E>> {
        public EnumFreqPair<E> read(Obj var1);
    }
}

