/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.bintrie;

import com.mayabot.nlp.collection.bintrie.BinTrieNode;
import java.util.List;

public abstract class AbstractTrieNode<V>
implements BinTrieNode<V> {
    public static final byte Status_Begin = 1;
    public static final byte Status_Continue = 2;
    public static final byte Status_End = 3;
    public static final byte Status_Null = -1;
    public final char _char;
    public byte status;
    public V value = null;
    public short level;

    public AbstractTrieNode(char _char) {
        this._char = _char;
    }

    public abstract List<AbstractTrieNode<V>> getChildren();

    public String toString() {
        return this._char + "[" + this.status + "]";
    }

    public V getParam(int i) {
        if (this.value != null) {
            if (this.value instanceof String[]) {
                String[] _p = (String[])this.value;
                if (_p.length > i) {
                    return (V)_p[i];
                }
            } else if (this.value instanceof List) {
                List list = (List)this.value;
                return (V)list.get(i);
            }
        }
        return null;
    }

    public boolean equals(char c) {
        return this._char == c;
    }

    public int hashCode() {
        return this._char;
    }

    @Override
    public int compareTo(char c) {
        if (this._char > c) {
            return 1;
        }
        if (this._char < c) {
            return -1;
        }
        return 0;
    }

    @Override
    public byte getStatus() {
        return this.status;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    static int binarySearch(BinTrieNode<?>[] branches, char _char) {
        int high = branches.length - 1;
        if (branches.length < 1) {
            return high;
        }
        int low = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = branches[mid].compareTo(_char);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

