/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.bintrie;

import com.mayabot.nlp.collection.Trie;
import com.mayabot.nlp.collection.bintrie.AbstractTrieNode;
import com.mayabot.nlp.collection.bintrie.ArrayTrieNode;
import com.mayabot.nlp.collection.bintrie.BinTrieNode;
import com.mayabot.nlp.collection.bintrie.TrieTreeAllMatcher;
import com.mayabot.nlp.collection.bintrie.TrieTreeForwardMaxMatcher;
import com.mayabot.nlp.collection.bintrie.TrieTreeMatcher;
import com.mayabot.nlp.hppc.CharObjectHashMap;
import com.mayabot.nlp.hppc.CharObjectMap;
import com.mayabot.t.google.common.collect.AbstractIterator;
import com.mayabot.t.google.common.collect.ImmutableSet;
import com.mayabot.t.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BinTrieTree<T>
implements Trie<T>,
BinTrieNode<T> {
    boolean rootChildUseMap = false;
    static final int max_width = 65536;
    private AbstractTrieNode<T>[] children;
    private CharObjectMap<AbstractTrieNode<T>> childrenMap;
    TrieNodeFactory<T> nodeFactory = ArrayTrieNode::new;

    BinTrieTree(boolean rootChildUseMap, TrieNodeFactory<T> nodeFactory) {
        this.rootChildUseMap = rootChildUseMap;
        this.nodeFactory = nodeFactory;
        this.reset();
    }

    public void reset() {
        if (this.rootChildUseMap) {
            this.childrenMap = new CharObjectHashMap<AbstractTrieNode<T>>(500);
        } else {
            this.children = new AbstractTrieNode[65536];
        }
    }

    public int rootChildCount() {
        if (this.childrenMap != null) {
            return this.childrenMap.size();
        }
        int c = 0;
        for (AbstractTrieNode<T> o : this.children) {
            if (o == null) continue;
            ++c;
        }
        return c;
    }

    public TrieTreeMatcher<T> newForwardMatcher(String text) {
        return new TrieTreeForwardMaxMatcher(this, text);
    }

    public TrieTreeMatcher<T> newAllMatcher(String text) {
        return new TrieTreeAllMatcher(this, text);
    }

    @Override
    public boolean containsKey(String key) {
        BinTrieNode<T> branch = this;
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char _char = key.charAt(i);
            if (branch == null) {
                return false;
            }
            branch = branch.findChild(_char);
        }
        if (branch == null) {
            return false;
        }
        return branch.getStatus() == 3 || branch.getStatus() == 2;
    }

    @Override
    public T get(char[] key) {
        BinTrieNode<T> branch = this;
        for (char _char : key) {
            if (branch == null) {
                return null;
            }
            branch = branch.findChild(_char);
        }
        if (branch == null) {
            return null;
        }
        if (branch.getStatus() != 3 && branch.getStatus() != 2) {
            return null;
        }
        return branch.getValue();
    }

    @Override
    public T get(char[] key, int offset, int len) {
        BinTrieNode<T> branch = this;
        for (int i = offset; i < len; ++i) {
            char _char = key[i];
            if (branch == null) {
                return null;
            }
            branch = branch.findChild(_char);
        }
        if (branch == null) {
            return null;
        }
        if (branch.getStatus() != 3 && branch.getStatus() != 2) {
            return null;
        }
        return branch.getValue();
    }

    @Override
    public T get(CharSequence key) {
        BinTrieNode branch = this.findNode(key);
        if (branch == null) {
            return null;
        }
        if (branch.getStatus() != 3 && branch.getStatus() != 2) {
            return null;
        }
        return branch.getValue();
    }

    public void put(String word, T value) {
        word = word.toLowerCase();
        BinTrieNode<T> point = this;
        int len = word.length();
        int lenIndex = len - 1;
        for (int i = 0; i < len; ++i) {
            char theChar = word.charAt(i);
            if (lenIndex == i) {
                point.addChildNode(this.nodeFactory.create(theChar, (byte)3, value));
            } else {
                point.addChildNode(this.nodeFactory.create(theChar, (byte)1, null));
            }
            point = point.findChild(theChar);
        }
    }

    public Set<Map.Entry<String, T>> prefixSearch(String key) {
        BinTrieNode node = this.findNode(key);
        if (node == null) {
            return ImmutableSet.of();
        }
        NodeHolder holder = new NodeHolder();
        IteratorKeys ite = new IteratorKeys(holder, (AbstractTrieNode)node, key);
        HashSet<Map.Entry<String, T>> set = Sets.newHashSet();
        while (ite.hasNext()) {
            String k = (String)ite.next();
            AbstractTrieNode v = holder.node;
            set.add(new AbstractMap.SimpleEntry(k, v.value));
        }
        return set;
    }

    public void remove(String key) {
        BinTrieNode<T> branch = this;
        char[] chars = key.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (branch == null) {
                return;
            }
            if (chars.length == i + 1) {
                branch.addChildNode(this.nodeFactory.create(chars[i], (byte)-1, null));
            }
            branch = branch.findChild(chars[i]);
        }
    }

    public void accessFullTireNode(TireNodeAccess<T> nodeAccess) {
        LinkedList<Object> stack = new LinkedList<Object>();
        if (this.childrenMap != null) {
            for (AbstractTrieNode node : this.childrenMap.values()) {
                stack.push(node);
            }
        } else {
            for (AbstractTrieNode<T> x2 : this.children) {
                if (x2 == null) continue;
                stack.push(x2);
            }
        }
        while (!stack.isEmpty()) {
            AbstractTrieNode node = (AbstractTrieNode)stack.pop();
            nodeAccess.access(node);
            List chl = node.getChildren();
            if (chl == null) continue;
            node.getChildren().forEach(x -> stack.push(x));
        }
    }

    public Iterator<String> keys(NodeHolder holder) {
        return new IteratorKeys(holder);
    }

    public Iterator<String> keys() {
        return new IteratorKeys(null);
    }

    public Iterable<Map.Entry<String, T>> entry() {
        return () -> new AbstractIterator<Map.Entry<String, T>>(){
            NodeHolder holder = new NodeHolder();
            Iterator ite = BinTrieTree.this.keys(this.holder);

            @Override
            protected Map.Entry<String, T> computeNext() {
                if (!this.ite.hasNext()) {
                    return (Map.Entry)this.endOfData();
                }
                String key = (String)this.ite.next();
                if (key != null) {
                    return new AbstractMap.SimpleEntry(key, this.holder.node.value);
                }
                return (Map.Entry)this.endOfData();
            }
        };
    }

    @Override
    public boolean contains(char c) {
        if (this.rootChildUseMap) {
            return this.childrenMap.containsKey(c);
        }
        return this.children[c] != null;
    }

    @Override
    public BinTrieNode<T> addChildNode(BinTrieNode<T> n) {
        AbstractTrieNode<T> node = (AbstractTrieNode<T>)n;
        AbstractTrieNode<T> oldNode = null;
        if (this.rootChildUseMap) {
            oldNode = this.childrenMap.get(node._char);
            if (oldNode == null) {
                this.childrenMap.put(node._char, node);
                oldNode = node;
            }
        } else {
            oldNode = this.children[node._char];
            if (oldNode == null) {
                this.children[node._char] = node;
                oldNode = node;
            }
        }
        switch (node.status) {
            case 1: {
                if (oldNode.status != 3) break;
                oldNode.status = (byte)2;
                break;
            }
            case 3: {
                if (oldNode.status == 1) {
                    oldNode.status = (byte)2;
                }
                oldNode.value = node.value;
            }
        }
        return oldNode;
    }

    @Override
    public AbstractTrieNode<T> findChild(char c) {
        if (this.rootChildUseMap) {
            return this.childrenMap.get(c);
        }
        if (c > '\u10000') {
            return null;
        }
        return this.children[c];
    }

    @Override
    public byte getStatus() {
        return 0;
    }

    @Override
    public T getValue() {
        return null;
    }

    @Override
    public int compareTo(char c) {
        return 0;
    }

    public CharObjectMap<AbstractTrieNode<T>> getChildrenMap() {
        return this.childrenMap;
    }

    public static interface TrieNodeFactory<T> {
        public BinTrieNode<T> create(char var1, byte var2, T var3);
    }

    class IteratorKeys
    extends AbstractIterator<String> {
        LinkedList<AbstractTrieNode<T>> stack = new LinkedList();
        char[] buffer = new char[Short.MAX_VALUE];
        NodeHolder holder;

        IteratorKeys(NodeHolder holder) {
            this.holder = holder;
            if (BinTrieTree.this.childrenMap != null) {
                for (AbstractTrieNode node : BinTrieTree.this.childrenMap.values()) {
                    this.stack.push(node);
                }
            } else {
                for (AbstractTrieNode x2 : BinTrieTree.this.children) {
                    if (x2 == null) continue;
                    this.stack.push(x2);
                }
            }
            this.stack.forEach(x -> {
                x.level = 1;
            });
        }

        IteratorKeys(NodeHolder holder, AbstractTrieNode<T> initNode, String prefix) {
            this.holder = holder;
            this.stack.push(initNode);
            this.stack.forEach(x -> {
                x.level = (short)prefix.length();
            });
            if (prefix.length() >= 2) {
                for (int i = 0; i < prefix.length() - 1; ++i) {
                    this.buffer[1 + i] = prefix.charAt(i);
                }
            }
        }

        @Override
        protected String computeNext() {
            if (this.stack.isEmpty()) {
                return (String)this.endOfData();
            }
            String n = this._next();
            while (n == null) {
                n = this._next();
                if (n != null) {
                    return n;
                }
                if (!this.stack.isEmpty()) continue;
                return (String)this.endOfData();
            }
            return n;
        }

        private String _next() {
            AbstractTrieNode node = this.stack.pop();
            this.buffer[node.level] = node._char;
            List<AbstractTrieNode<AbstractTrieNode>> chl = node.getChildren();
            if (chl != null) {
                short level = (short)(node.level + 1);
                chl.forEach(x -> {
                    x.level = level;
                    this.stack.push((AbstractTrieNode)x);
                });
            }
            if (node.status == 2 || node.status == 3) {
                if (this.holder != null) {
                    this.holder.node = node;
                }
                return new String(this.buffer, 1, (int)node.level);
            }
            return null;
        }
    }

    public static class NodeHolder {
        AbstractTrieNode node;

        public AbstractTrieNode getNode() {
            return this.node;
        }
    }

    public static interface TireNodeAccess<T> {
        public void access(AbstractTrieNode<T> var1);
    }
}

