/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.bintrie;

import com.mayabot.nlp.collection.bintrie.AbstractTrieNode;
import com.mayabot.nlp.collection.bintrie.BinTrieNode;
import com.mayabot.nlp.hppc.CharObjectHashMap;
import com.mayabot.t.google.common.collect.Lists;
import java.util.List;

public class HashTrieNode<T>
extends AbstractTrieNode<T> {
    private CharObjectHashMap<HashTrieNode<T>> map;

    HashTrieNode(char _char, byte status, T param) {
        super(_char);
        this.status = status;
        this.value = param;
    }

    @Override
    public List<AbstractTrieNode<T>> getChildren() {
        if (this.map == null) {
            return null;
        }
        return Lists.newArrayList(this.map.values());
    }

    @Override
    public BinTrieNode<T> addChildNode(BinTrieNode<T> c) {
        HashTrieNode<T> branch;
        AbstractTrieNode child = (AbstractTrieNode)c;
        if (this.map == null) {
            this.map = new CharObjectHashMap();
        }
        if ((branch = this.map.get(child._char)) != null) {
            switch (child.status) {
                case -1: {
                    branch.status = 1;
                    break;
                }
                case 1: {
                    if (branch.status != 3) break;
                    branch.status = (byte)2;
                    break;
                }
                case 3: {
                    if (branch.status != 3) {
                        branch.status = (byte)2;
                    }
                    branch.value = child.value;
                }
            }
        } else {
            this.map.put(child._char, (HashTrieNode<T>)((HashTrieNode)child));
        }
        return this.map.get(child._char);
    }

    @Override
    public HashTrieNode<T> findChild(char c) {
        if (this.map != null) {
            return this.map.get(c);
        }
        return null;
    }

    @Override
    public boolean contains(char c) {
        if (this.map != null) {
            return this.map.containsKey(c);
        }
        return false;
    }
}

