/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.dat;

import com.mayabot.nlp.collection.dat.DoubleArrayTrie;

public class DATMatcher {
    private int begin;
    private int length;
    private int index;
    private char[] charArray;
    private int last;
    private int i;
    private int arrayLength;
    private DoubleArrayTrie dat;
    private int[] base;
    private int[] check;

    DATMatcher(DoubleArrayTrie dat, String text, int offset) {
        this(dat, text.toCharArray(), offset);
    }

    DATMatcher(DoubleArrayTrie dat, char[] charArray, int offset) {
        this.charArray = charArray;
        this.dat = dat;
        this.i = offset;
        this.last = dat.base[0];
        this.arrayLength = charArray.length;
        this.begin = this.arrayLength == 0 ? -1 : offset;
        this.base = dat.base;
        this.check = dat.check;
    }

    public boolean next() {
        int b = this.last;
        while (true) {
            int p;
            if (this.i == this.arrayLength) {
                ++this.begin;
                if (this.begin == this.arrayLength) break;
                this.i = this.begin;
                b = this.base[0];
            }
            if (b != this.check[p = b + this.charArray[this.i] + 1]) {
                this.i = this.begin++;
                if (this.begin == this.arrayLength) break;
                b = this.base[0];
            } else {
                b = this.base[p];
                p = b;
                int n = this.base[p];
                if (b == this.check[p] && n < 0) {
                    this.length = this.i - this.begin + 1;
                    this.index = -n - 1;
                    this.last = b;
                    ++this.i;
                    return true;
                }
            }
            ++this.i;
        }
        return false;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getLength() {
        return this.length;
    }

    public int getIndex() {
        return this.index;
    }
}

