/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.dat;

import com.mayabot.nlp.collection.dat.DATLongMatcher;
import com.mayabot.nlp.collection.dat.DATMatcher;
import com.mayabot.nlp.collection.dat.DoubleArrayMaker;
import com.mayabot.nlp.utils.DataInOutputUtils;
import com.mayabot.t.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class DoubleArrayTrie {
    public int[] check;
    public int[] base;
    private int size;

    public DoubleArrayTrie(DataInput in) throws IOException {
        this.size = in.readInt();
        this.base = DataInOutputUtils.readIntArray(in);
        this.check = DataInOutputUtils.readIntArray(in);
    }

    public DoubleArrayTrie(TreeSet<String> set) {
        this(Lists.newArrayList(set));
    }

    public DoubleArrayTrie(List<String> sortedKeys) {
        DoubleArrayMaker datDoubleArrayMaker = new DoubleArrayMaker(sortedKeys);
        datDoubleArrayMaker.build();
        this.size = sortedKeys.size();
        this.check = datDoubleArrayMaker.getCheck();
        this.base = datDoubleArrayMaker.getBase();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size);
        DataInOutputUtils.writeIntArray(this.base, out);
        DataInOutputUtils.writeIntArray(this.check, out);
    }

    public int size() {
        return this.size;
    }

    public DATMatcher matcher(String text, int offset) {
        return new DATMatcher(this, text, offset);
    }

    public DATMatcher matcher(char[] text, int offset) {
        return new DATMatcher(this, text, offset);
    }

    public DATMatcher matcher(String text) {
        return new DATMatcher(this, text, 0);
    }

    public DATMatcher matcher(char[] text) {
        return new DATMatcher(this, text, 0);
    }

    public DATLongMatcher matcherLong(String text, int offset) {
        return new DATLongMatcher(this, text, offset);
    }

    public DATLongMatcher matcherLong(char[] text, int offset) {
        return new DATLongMatcher(this, text, offset);
    }

    public DATLongMatcher matcherLong(String text) {
        return new DATLongMatcher(this, text, 0);
    }

    public DATLongMatcher matcherLong(char[] text) {
        return new DATLongMatcher(this, text, 0);
    }

    public int indexOf(CharSequence key) {
        return this.indexOf(key, 0, 0, 0);
    }

    public int indexOf(CharSequence key, int pos, int len, int nodePos) {
        int p;
        if (len <= 0) {
            len = key.length();
        }
        if (nodePos <= 0) {
            nodePos = 0;
        }
        int result = -1;
        int b = this.base[nodePos];
        for (int i = pos; i < pos + len; ++i) {
            p = b + key.charAt(i) + 1;
            if (b != this.check[p]) {
                return result;
            }
            b = this.base[p];
        }
        p = b;
        int n = this.base[p];
        if (b == this.check[p] && n < 0) {
            result = -n - 1;
        }
        return result;
    }

    public int indexOf(char ch) {
        int result = -1;
        int b = this.base[0];
        int p = b + ch + 1;
        if (b != this.check[p]) {
            return result;
        }
        b = this.base[p];
        p = b;
        int n = this.base[p];
        if (b == this.check[p] && n < 0) {
            result = -n - 1;
        }
        return result;
    }

    public int indexOf(char[] chars, int pos, int len) {
        return this.indexOf(chars, pos, len, 0);
    }

    public int indexOf(char[] keyChars, int pos, int len, int nodePos) {
        int p;
        if (len <= 0) {
            len = keyChars.length;
        }
        if (nodePos <= 0) {
            nodePos = 0;
        }
        int result = -1;
        int b = this.base[nodePos];
        for (int i = pos; i < len + pos; ++i) {
            p = b + keyChars[i] + 1;
            if (b != this.check[p]) {
                return result;
            }
            b = this.base[p];
        }
        p = b;
        int n = this.base[p];
        if (b == this.check[p] && n < 0) {
            result = -n - 1;
        }
        return result;
    }

    public boolean containsKey(String key) {
        return this.indexOf(key) >= 0;
    }

    private int transition(String path) {
        return this.transition(path.toCharArray());
    }

    private int transition(char[] path) {
        int p;
        int b = this.base[0];
        for (int i = 0; i < path.length; ++i) {
            p = b + path[i] + 1;
            if (b != this.check[p]) {
                return -1;
            }
            b = this.base[p];
        }
        p = b;
        return p;
    }

    private int transition(char c, int from) {
        int b = from;
        int p = b + c + 1;
        if (b != this.check[p]) {
            return -1;
        }
        b = this.base[p];
        return b;
    }

    private int transition(String path, int from) {
        int p;
        int b = from;
        for (int i = 0; i < path.length(); ++i) {
            p = b + path.charAt(i) + 1;
            if (b != this.check[p]) {
                return -1;
            }
            b = this.base[p];
        }
        p = b;
        return p;
    }

    public int output(int state) {
        if (state < 0) {
            return -1;
        }
        int n = this.base[state];
        if (state == this.check[state] && n < 0) {
            return -n - 1;
        }
        return -1;
    }

    protected int transition(int current, char c) {
        int b = this.base[current];
        int p = b + c + 1;
        if (b != this.check[p]) {
            return -1;
        }
        b = this.base[p];
        p = b;
        return p;
    }

    public int getNonzeroSize() {
        int result = 0;
        for (int i = 0; i < this.check.length; ++i) {
            if (this.check[i] == 0) continue;
            ++result;
        }
        return result;
    }

    public List<Integer> commonPrefixSearch(String key) {
        return this.commonPrefixSearch(key, 0, 0, 0);
    }

    public List<Integer> commonPrefixSearch(String key, int pos, int len, int nodePos) {
        if (len <= 0) {
            len = key.length();
        }
        if (nodePos <= 0) {
            nodePos = 0;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int b = this.base[nodePos];
        for (int i = pos; i < len; ++i) {
            int p = b + key.charAt(i) + 1;
            if (b != this.check[p]) {
                return result;
            }
            b = this.base[p];
            p = b;
            int n = this.base[p];
            if (b != this.check[p] || n >= 0) continue;
            result.add(-n - 1);
        }
        return result;
    }

    public List<Integer> commonPrefixSearch(char[] key) {
        return this.commonPrefixSearch(key, 0, 0, 0);
    }

    public List<Integer> commonPrefixSearch(char[] key, int offset) {
        return this.commonPrefixSearch(key, offset, 0, 0);
    }

    public List<Integer> commonPrefixSearch(char[] key, int pos, int len, int nodePos) {
        if (len <= 0) {
            len = key.length;
        }
        if (nodePos <= 0) {
            nodePos = 0;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int b = this.base[nodePos];
        for (int i = pos; i < len; ++i) {
            int p = b + key[i] + 1;
            if (b != this.check[p]) {
                return result;
            }
            b = this.base[p];
            p = b;
            int n = this.base[p];
            if (b != this.check[p] || n >= 0) continue;
            result.add(-n - 1);
        }
        return result;
    }

    public LinkedList<Map.Entry<String, Integer>> commonPrefixSearchWithValue(char[] keyChars, int begin) {
        int n;
        int p;
        int len = keyChars.length;
        LinkedList<Map.Entry<String, Integer>> result = new LinkedList<Map.Entry<String, Integer>>();
        int b = this.base[0];
        for (int i = begin; i < len; ++i) {
            p = b;
            n = this.base[p];
            if (b == this.check[p] && n < 0) {
                result.add(new AbstractMap.SimpleEntry<String, Integer>(new String(keyChars, begin, i - begin), -n - 1));
            }
            if (b != this.check[p = b + keyChars[i] + 1]) {
                return result;
            }
            b = this.base[p];
        }
        p = b;
        n = this.base[p];
        if (b == this.check[p] && n < 0) {
            result.add(new AbstractMap.SimpleEntry<String, Integer>(new String(keyChars, begin, len - begin), -n - 1));
        }
        return result;
    }
}

