/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common;

import com.mayabot.t.google.common.collect.ImmutableMap;
import com.mayabot.t.google.common.collect.ImmutableSet;
import com.mayabot.t.google.common.primitives.Ints;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class EnumFreqPair<E extends Enum> {
    private ImmutableMap<E, Integer> labelMap = ImmutableMap.of();

    public EnumFreqPair() {
    }

    public void writeItem(DataOutput out) {
        try {
            int size = this.labelMap.size();
            switch (size) {
                case 0: {
                    out.writeUTF("NULL");
                    break;
                }
                case 1: {
                    Map.Entry next = (Map.Entry)((ImmutableSet)this.labelMap.entrySet()).iterator().next();
                    String name = ((Enum)next.getKey()).name();
                    Integer f = (Integer)next.getValue();
                    out.writeUTF(name + "," + f);
                    break;
                }
                default: {
                    StringBuilder sb = new StringBuilder();
                    int count = 0;
                    for (Map.Entry e : this.labelMap.entrySet()) {
                        sb.append(((Enum)e.getKey()).name()).append(",").append(e.getValue());
                        if (++count == size) continue;
                        sb.append(",");
                    }
                    out.writeUTF(sb.toString());
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void readItem(DataInput in, Function<String, E> function) {
        try {
            String json = in.readUTF();
            if ("NULL".equals(json)) {
                this.labelMap = ImmutableMap.of();
            } else {
                ImmutableMap.Builder<E, Integer> builder = ImmutableMap.builder();
                String[] split = json.split(",");
                for (int i = 0; i < split.length; i += 2) {
                    builder.put(function.apply(split[i]), Integer.parseInt(split[i + 1]));
                }
                this.labelMap = builder.build();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public EnumFreqPair(E ... labels) {
        this();
        ImmutableMap.Builder<E, Integer> builder = ImmutableMap.builder();
        for (E label : labels) {
            builder.put(label, 1);
        }
        this.labelMap = builder.build();
    }

    public EnumFreqPair(E label, int frequency) {
        this();
        this.labelMap = ImmutableMap.of(label, frequency);
    }

    public EnumFreqPair(E label, int frequency, E label2, int freq) {
        this();
        this.labelMap = ImmutableMap.of(label, frequency, label2, freq);
    }

    public EnumFreqPair(E label, long frequency) {
        this();
        this.labelMap = ImmutableMap.of(label, (int)frequency);
    }

    @SafeVarargs
    public static <E extends Enum<E>> EnumFreqPair<E> create(E ... x) {
        return new EnumFreqPair(x);
    }

    public static <E extends Enum> EnumFreqPair<E> create(List<String> params, Function<String, E> f) {
        EnumFreqPair<E> x = new EnumFreqPair<E>();
        ImmutableMap.Builder<E, Integer> builder = ImmutableMap.builder();
        Iterator<String> ite = params.iterator();
        while (ite.hasNext()) {
            String key = ite.next();
            String value = ite.next();
            builder.put(f.apply(key), Ints.tryParse(value));
        }
        x.labelMap = builder.build();
        return x;
    }

    public Map<E, Integer> getMap() {
        return this.labelMap;
    }

    public E oneKey() {
        return (E)((Enum)((Map.Entry)((ImmutableSet)this.labelMap.entrySet()).iterator().next()).getKey());
    }

    public Set<E> keySet() {
        return this.labelMap.keySet();
    }

    public int size() {
        return this.labelMap.size();
    }

    public boolean containsLabel(E label) {
        return this.labelMap.containsKey(label);
    }

    public int getFrequency(E label) {
        return this.labelMap.get(label);
    }

    public String toString() {
        return this.labelMap.toString();
    }
}

