/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common;

import com.mayabot.nlp.common.ArraySizingStrategy;
import com.mayabot.nlp.common.BoundedProportionalArraySizingStrategy;
import com.mayabot.nlp.common.IntArray;
import java.util.Arrays;

public class IntArrayBuilder {
    public static final int[] EMPTY_ARRAY = new int[0];
    public int[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public IntArrayBuilder() {
        this(8);
    }

    public IntArrayBuilder(int expectedElements) {
        this(expectedElements, 10, 0x7FFFFFDF, 1.5f);
    }

    public IntArrayBuilder(int expectedElements, int minGrow, int maxGrow, float ratio) {
        this.resizer = new BoundedProportionalArraySizingStrategy(minGrow, maxGrow, ratio);
        this.ensureCapacity(expectedElements);
    }

    public void add(int e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(int e1, int e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(int[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public final void add(int ... elements) {
        this.add(elements, 0, elements.length);
    }

    public IntArray get() {
        return new IntArray(this.buffer, this.elementsCount);
    }

    public IntArray getCompactIntArray() {
        if (this.buffer.length - this.elementsCount > 128 && (float)this.buffer.length * 1.0f / (float)this.elementsCount > 1.15f) {
            this.trimToSize();
        }
        return new IntArray(this.buffer, this.elementsCount);
    }

    public void ensureCapacity(int expectedElements) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (expectedElements > bufferLen) {
            this.ensureBufferSpace(expectedElements - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + expectedAdditions > bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            this.buffer = Arrays.copyOf(this.buffer, newSize);
        }
    }

    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }
}

