/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common;

import com.mayabot.nlp.utils.Characters;
import com.mayabot.t.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class TokenizerSplitter {
    private int fromIndex = -1;
    private int toIndex = -1;
    private CharSequence sequence;
    private int length;
    private int point = 0;

    public static TokenizerSplitter create(CharSequence sequence) {
        return new TokenizerSplitter(sequence);
    }

    private TokenizerSplitter(CharSequence sequence) {
        this.rest(sequence);
    }

    public void rest(CharSequence sequence) {
        this.sequence = sequence;
        this.length = sequence.length();
    }

    public boolean next() {
        if (this.point == this.length) {
            return false;
        }
        while (this.point < this.length && this.isSpliter(this.sequence.charAt(this.point))) {
            ++this.point;
        }
        if (this.point == this.length) {
            return false;
        }
        this.fromIndex = this.point;
        while (this.point < this.length && !this.isSpliter(this.sequence.charAt(this.point))) {
            ++this.point;
        }
        this.toIndex = this.point;
        return true;
    }

    public CharSequence group() {
        return this.sequence.subSequence(this.fromIndex, this.toIndex);
    }

    public final int from() {
        return this.fromIndex;
    }

    public final int to() {
        return this.toIndex;
    }

    private boolean isSpliter(char c) {
        return Characters.isPunctuation(c);
    }

    public static List<String> parts(String string) {
        TokenizerSplitter p = TokenizerSplitter.create(string);
        ArrayList<String> list = Lists.newArrayList();
        while (p.next()) {
            list.add((String)p.group());
        }
        return list;
    }

    public static void main(String[] args) {
        System.out.println(TokenizerSplitter.parts(""));
        System.out.println(TokenizerSplitter.parts(",abc,efg"));
        System.out.println(TokenizerSplitter.parts(",,abc,efg."));
        System.out.println(TokenizerSplitter.parts(",,abc efg."));
        System.out.println(TokenizerSplitter.parts("abcefg"));
        System.out.println(TokenizerSplitter.parts("ou may skip through a book, reading only those passages concerned  "));
        System.out.println(TokenizerSplitter.parts("\u4f60\u53ef\u4ee5\u8df3\u8bfb\u4e00\u672c\u4e66\uff0c\u53ea\u62e3\u90a3\u4e9b\u6709\u5173\u7684\u6bb5\u843d\u8bfb\u4e00\u4e0b\u5373\u53ef\u3002"));
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            TokenizerSplitter.parts("\u4f60\u53ef\u4ee5\u8df3\u8bfb\u4e00\u672c\u4e66\uff0c\u53ea\u62e3\u90a3\u4e9b\u6709\u5173\u7684\u6bb5\u843d\u8bfb\u4e00\u4e0b\u5373\u53ef\u3002");
        }
        long t2 = System.currentTimeMillis();
        System.out.println(t2 - t1);
    }
}

