/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common;

import com.mayabot.t.google.common.annotations.VisibleForTesting;
import com.mayabot.t.google.common.base.Preconditions;
import com.mayabot.t.google.common.math.LongMath;
import com.mayabot.t.google.common.primitives.Ints;
import com.mayabot.t.google.common.primitives.UnsignedBytes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Random;

public class TwoIntBloomFilter {
    private final BitArray bits;
    private final int numHashFunctions;
    private int seed = 0;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;

    public static void main(String[] args) {
        int i;
        TwoIntBloomFilter bloomFilter = TwoIntBloomFilter.create(3000000);
        bloomFilter.put(1, 2);
        bloomFilter.put(1, 3);
        Random random = new Random(0L);
        for (i = 0; i < 3000000; ++i) {
            int a = random.nextInt(1000);
            int b = random.nextInt(1000);
            bloomFilter.put(a, b);
        }
        for (i = 0; i < 10000000; ++i) {
            bloomFilter.mightContain(1, 3);
            bloomFilter.mightContain(12, 3);
        }
        long t1 = System.currentTimeMillis();
        for (int i2 = 0; i2 < 10000000; ++i2) {
            bloomFilter.mightContain(1, 3);
            bloomFilter.mightContain(12, 3);
        }
        long t2 = System.currentTimeMillis();
        System.out.println(t2 - t1);
        System.out.println(bloomFilter.mightContain(2, 3));
        System.out.println(bloomFilter.mightContain(1, 3));
        System.out.println(bloomFilter.mightContain(473, 262));
        System.out.println(bloomFilter.mightContain(4731, 262));
        System.out.println(bloomFilter.mightContain(47131, 262));
    }

    private TwoIntBloomFilter(BitArray bits, int numHashFunctions) {
        Preconditions.checkArgument(numHashFunctions > 0, "numHashFunctions (%s) must be > 0", numHashFunctions);
        Preconditions.checkArgument(numHashFunctions <= 255, "numHashFunctions (%s) must be <= 255", numHashFunctions);
        this.bits = Preconditions.checkNotNull(bits);
        this.numHashFunctions = numHashFunctions;
    }

    public boolean mightContain(int a, int b) {
        long bitSize = this.bits.bitSize();
        int hash1 = this.hashInt(a);
        int hash2 = this.hashInt(b);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bits.get((long)combinedHash % bitSize)) continue;
            return false;
        }
        return true;
    }

    public boolean put(int a, int b) {
        long bitSize = this.bits.bitSize();
        int hash1 = this.hashInt(a);
        int hash2 = this.hashInt(b);
        boolean bitsChanged = false;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            bitsChanged |= this.bits.set((long)combinedHash % bitSize);
        }
        return bitsChanged;
    }

    public int hashInt(int input) {
        int k1 = TwoIntBloomFilter.mixK1(input);
        int h1 = TwoIntBloomFilter.mixH1(this.seed, k1);
        return TwoIntBloomFilter.fmix(h1, 4);
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fmix(int h1, int length) {
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public double expectedFpp() {
        return Math.pow((double)this.bits.bitCount() / (double)this.bitSize(), this.numHashFunctions);
    }

    @VisibleForTesting
    long bitSize() {
        return this.bits.bitSize();
    }

    public static TwoIntBloomFilter create(int expectedInsertions) {
        return TwoIntBloomFilter.create((long)expectedInsertions, 0.03);
    }

    public static TwoIntBloomFilter create(int expectedInsertions, double fpp) {
        return TwoIntBloomFilter.create((long)expectedInsertions, fpp);
    }

    @VisibleForTesting
    public static TwoIntBloomFilter create(long expectedInsertions, double fpp) {
        Preconditions.checkArgument(expectedInsertions >= 0L, "Expected insertions (%s) must be >= 0", expectedInsertions);
        Preconditions.checkArgument(fpp > 0.0, "False positive probability (%s) must be > 0.0", fpp);
        Preconditions.checkArgument(fpp < 1.0, "False positive probability (%s) must be < 1.0", fpp);
        if (expectedInsertions == 0L) {
            expectedInsertions = 1L;
        }
        long numBits = TwoIntBloomFilter.optimalNumOfBits(expectedInsertions, fpp);
        int numHashFunctions = TwoIntBloomFilter.optimalNumOfHashFunctions(expectedInsertions, numBits);
        try {
            return new TwoIntBloomFilter(new BitArray(numBits), numHashFunctions);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not create BloomFilter of " + numBits + " bits", e);
        }
    }

    @VisibleForTesting
    static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }

    @VisibleForTesting
    static long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    public void writeTo(DataOutput dout) throws IOException {
        dout.writeByte(UnsignedBytes.checkedCast(this.numHashFunctions));
        dout.writeInt(this.bits.data.length);
        for (long value : this.bits.data) {
            dout.writeLong(value);
        }
    }

    public static TwoIntBloomFilter readFrom(DataInput din) throws IOException {
        Preconditions.checkNotNull(din, "InputStream");
        int strategyOrdinal = -1;
        int numHashFunctions = -1;
        int dataLength = -1;
        try {
            numHashFunctions = UnsignedBytes.toInt(din.readByte());
            dataLength = din.readInt();
            long[] data = new long[dataLength];
            for (int i = 0; i < data.length; ++i) {
                data[i] = din.readLong();
            }
            return new TwoIntBloomFilter(new BitArray(data), numHashFunctions);
        }
        catch (RuntimeException e) {
            IOException ioException = new IOException("Unable to deserialize BloomFilter from InputStream. strategyOrdinal: " + strategyOrdinal + " numHashFunctions: " + numHashFunctions + " dataLength: " + dataLength);
            ioException.initCause(e);
            throw ioException;
        }
    }

    static final class BitArray {
        final long[] data;
        long bitCount;

        BitArray(long bits) {
            this(new long[Ints.checkedCast(LongMath.divide(bits, 64L, RoundingMode.CEILING))]);
        }

        BitArray(long[] data) {
            Preconditions.checkArgument(data.length > 0, "data length is zero!");
            this.data = data;
            long bitCount = 0L;
            for (long value : data) {
                bitCount += (long)Long.bitCount(value);
            }
            this.bitCount = bitCount;
        }

        boolean set(long index) {
            if (!this.get(index)) {
                int n = (int)(index >>> 6);
                this.data[n] = this.data[n] | 1L << (int)index;
                ++this.bitCount;
                return true;
            }
            return false;
        }

        boolean get(long index) {
            return (this.data[(int)(index >>> 6)] & 1L << (int)index) != 0L;
        }

        long bitSize() {
            return (long)this.data.length * 64L;
        }

        long bitCount() {
            return this.bitCount;
        }

        BitArray copy() {
            return new BitArray((long[])this.data.clone());
        }

        void putAll(BitArray array) {
            Preconditions.checkArgument(this.data.length == array.data.length, "BitArrays must be of equal length (%s != %s)", this.data.length, array.data.length);
            this.bitCount = 0L;
            for (int i = 0; i < this.data.length; ++i) {
                int n = i;
                this.data[n] = this.data[n] | array.data[i];
                this.bitCount += (long)Long.bitCount(this.data[i]);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof BitArray) {
                BitArray bitArray = (BitArray)o;
                return Arrays.equals(this.data, bitArray.data);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

