/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common.matrix;

import com.mayabot.nlp.common.matrix.TransformMatrix;
import com.mayabot.nlp.resources.NlpResource;
import java.io.IOException;
import java.io.InputStream;

public class EnumTransformMatrix<E extends Enum<E>> {
    private TransformMatrix transformMatrix = new TransformMatrix();

    public EnumTransformMatrix(NlpResource resource) throws IOException {
        try (InputStream in = resource.openInputStream();){
            this.transformMatrix.load(in);
        }
    }

    public int getFrequency(E from, E to) {
        return this.transformMatrix.getFrequency(((Enum)from).name(), ((Enum)to).name());
    }

    public long getTotalFrequency(E from) {
        return this.transformMatrix.getTotalFrequency(((Enum)from).name());
    }

    public long getTotalFrequency() {
        return this.transformMatrix.getTotalFrequency();
    }

    public String toString() {
        return this.transformMatrix.toString();
    }

    public double getTP(E from, E to) {
        Double x = this.transformMatrix.getTP(((Enum)from).name(), ((Enum)to).name());
        if (x != null) {
            return x;
        }
        return 0.0;
    }
}

