/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common.matrix;

import com.mayabot.nlp.common.QuickStringDoubleTable;
import com.mayabot.nlp.common.QuickStringIntTable;
import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.t.google.common.base.Splitter;
import com.mayabot.t.google.common.collect.ArrayTable;
import com.mayabot.t.google.common.collect.ImmutableCollection;
import com.mayabot.t.google.common.collect.ImmutableList;
import com.mayabot.t.google.common.collect.ImmutableMap;
import com.mayabot.t.google.common.collect.Maps;
import com.mayabot.t.google.common.io.ByteSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TransformMatrix {
    private QuickStringIntTable matrix;
    private ImmutableMap<String, Long> total;
    private long totalFrequency;
    public ImmutableList<String> states;
    public ImmutableMap<String, Double> start_probability;
    public QuickStringDoubleTable transititon_probability;

    public double getTP(String a, String b) {
        double d = this.transititon_probability.get(a, b);
        if (d == Double.MIN_VALUE) {
            return 0.0;
        }
        return d;
    }

    public int getFrequency(String from, String to) {
        int v = this.matrix.get(from, to);
        if (v == Integer.MIN_VALUE) {
            return 0;
        }
        return v;
    }

    public boolean load(ByteSource source) throws IOException {
        try (InputStream inputStream = source.openBufferedStream();){
            boolean bl = this.load(inputStream);
            return bl;
        }
    }

    public boolean load(NlpResource resource) throws IOException {
        try (InputStream inputStream = resource.openInputStream();){
            boolean bl = this.load(inputStream);
            return bl;
        }
    }

    public boolean load(InputStream in) throws IOException {
        Splitter splitter = Splitter.on(',').trimResults();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            String firstLine = br.readLine();
            List<String> lablist = splitter.splitToList(firstLine);
            ArrayTable<String, String, Integer> matrix = ArrayTable.create(lablist.subList(1, lablist.size()), lablist.subList(1, lablist.size()));
            while ((line = br.readLine()) != null) {
                List<String> paramArray = splitter.splitToList(line);
                String row_lable = paramArray.get(0);
                Map<String, Integer> row = matrix.row(row_lable);
                for (int i = 1; i < paramArray.size(); ++i) {
                    row.put(lablist.get(i), Integer.parseInt(paramArray.get(i)));
                }
            }
            this.matrix = new QuickStringIntTable(matrix);
            this.tongji(matrix);
        }
        return true;
    }

    private void tongji(ArrayTable<String, String, Integer> matrix) {
        HashMap<String, Long> _total = Maps.newHashMap();
        for (String label : matrix.rowKeyList()) {
            int x;
            long v1 = 0L;
            long v2 = 0L;
            Iterator iterator = matrix.row(label).values().iterator();
            while (iterator.hasNext()) {
                x = iterator.next();
                v1 += (long)x;
            }
            iterator = matrix.column(label).values().iterator();
            while (iterator.hasNext()) {
                x = iterator.next();
                v2 += (long)x;
            }
            _total.put(label, v1 + v2 - (long)matrix.get(label, label).intValue());
        }
        this.total = ImmutableMap.copyOf(_total);
        long _tf = 0L;
        Iterator v1 = ((ImmutableCollection)this.total.values()).iterator();
        while (v1.hasNext()) {
            long x = (Long)v1.next();
            _tf += x;
        }
        this.totalFrequency = _tf;
        this.states = matrix.rowKeyList();
        HashMap<String, Double> _start_probability = Maps.newHashMap();
        for (String label : this.states) {
            double frequency = (double)this.total.get(label).longValue() + 1.0E-8;
            _start_probability.put(label, -Math.log(frequency / (double)this.totalFrequency));
        }
        this.start_probability = ImmutableMap.copyOf(_start_probability);
        ArrayTable<String, String, Double> transititon_probability = ArrayTable.create(matrix.rowKeyList(), matrix.columnKeyList());
        for (String from : this.states) {
            for (String to : this.states) {
                double frequency = (double)matrix.get(from, to).intValue() + 1.0E-8;
                transititon_probability.put(from, to, -Math.log(frequency / (double)this.total.get(from).longValue()));
            }
        }
        this.transititon_probability = new QuickStringDoubleTable(transititon_probability);
    }

    public long getTotalFrequency(String from) {
        Long v = this.total.get(from);
        if (v == null) {
            return 0L;
        }
        return v;
    }

    public long getTotalFrequency() {
        return this.totalFrequency;
    }
}

