/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fst;

import com.mayabot.nlp.fst.FstCondition;
import com.mayabot.nlp.fst.FstFounder;
import com.mayabot.nlp.fst.FstMatcher;
import com.mayabot.nlp.fst.FstNode;
import com.mayabot.t.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;

public class FST<T> {
    public static final String Start_ID = "Start";
    private boolean fluze = false;
    private FstNode<T> startNode;
    private Map<String, FstNode<T>> nodeMap = Maps.newHashMap();

    public FST() {
        this.startNode = FstNode.createStartNode(this);
    }

    public FstFounder<T> newFounder() {
        return new FstFounder(this);
    }

    public FstMatcher<T, T> newMatcher(Iterable<T> date) {
        return new FstMatcher(this, date);
    }

    public <R> FstMatcher<T, R> newMatcher(Iterable<R> date, Function<R, T> function) {
        return new FstMatcher<T, R>(this, date, function);
    }

    public FstMatcher<T, T> newMatcher(T[] date) {
        return new FstMatcher(this, date);
    }

    public <R> FstMatcher<T, R> newMatcher(R[] date, Function<R, T> function) {
        return new FstMatcher<T, R>(this, date, function);
    }

    public FstNode<T> $(String nodeId) {
        if (Start_ID.equals(nodeId) || "^".equals(nodeId)) {
            return this.startNode;
        }
        if (this.nodeMap.containsKey(nodeId)) {
            return this.nodeMap.get(nodeId);
        }
        FstNode node = null;
        node = nodeId.startsWith("$$") ? FstNode.createTerminalNode(this, nodeId, true) : (nodeId.startsWith("$") ? FstNode.createTerminalNode(this, nodeId, false) : FstNode.createNode(this, nodeId));
        this.nodeMap.put(nodeId, node);
        return node;
    }

    public FstNode<T> start() {
        return this.getStartNode();
    }

    public FST<T> link(String from, String to, FstCondition<T> transformCondition) {
        this.$(from).edge(transformCondition, to);
        return this;
    }

    public FST<T> linkIfReadEndFlag(String from, String to) {
        this.$(from).edge((x, y) -> x == Integer.MAX_VALUE, to);
        return this;
    }

    public void frozen() {
        this.fluze = true;
    }

    public FstNode<T> getStartNode() {
        return this.startNode;
    }
}

