/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fst;

import com.mayabot.t.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;

@FunctionalInterface
public interface FstCondition<T> {
    public static final FstCondition readEndFlag = (index, obj) -> index == Integer.MAX_VALUE;

    public boolean test(int var1, T var2);

    default public FstCondition<T> not() {
        return (index, obj) -> !this.test(index, obj);
    }

    public static <T> FstCondition<T> not(final FstCondition<T> condition) {
        return new FstCondition<T>(){

            @Override
            public boolean test(int index, T obj) {
                return !condition.test(index, obj);
            }
        };
    }

    public static <Test, R> FstCondition<R> predicate(final Test test, final BiPredicate<Test, R> m) {
        return new FstCondition<R>(){

            @Override
            public boolean test(int index, R obj) {
                if (test == null) {
                    return false;
                }
                return m.test(test, obj);
            }
        };
    }

    public static <R> FstCondition<R> predicate(final Predicate<R> predicate) {
        return new FstCondition<R>(){

            @Override
            public boolean test(int index, R obj) {
                return predicate.test(obj);
            }
        };
    }

    public static <T> FstCondition<T> pattern(final Pattern pattern) {
        return new FstCondition<T>(){

            @Override
            public boolean test(int index, T obj) {
                if (obj == null) {
                    return false;
                }
                return pattern.matcher(obj.toString()).find();
            }
        };
    }

    public static <T> FstCondition<T> pattern(String _pattern) {
        final Pattern pattern = Pattern.compile(_pattern);
        return new FstCondition<T>(){

            @Override
            public boolean test(int index, T obj) {
                if (obj == null) {
                    return false;
                }
                return pattern.matcher(obj.toString()).find();
            }
        };
    }

    public static <T> FstCondition<T> eq(T testObj) {
        return FstCondition.predicate(testObj, (t, y) -> t.equals(y));
    }

    public static <T> FstCondition<T> in(final Set<T> set) {
        return new FstCondition<T>(){

            @Override
            public boolean test(int index, T obj) {
                if (obj == null) {
                    return false;
                }
                return set.contains(obj);
            }
        };
    }

    public static <T> FstCondition<T> NULL() {
        return new FstCondition<T>(){

            @Override
            public boolean test(int index, T obj) {
                return obj == null;
            }
        };
    }

    public static <T> FstCondition<T> NotNull() {
        return new FstCondition<T>(){

            @Override
            public boolean test(int index, T obj) {
                return obj != null;
            }
        };
    }

    public static <T> FstCondition<T> FALSE() {
        return new FstCondition<T>(){

            @Override
            public boolean test(int index, T obj) {
                return false;
            }
        };
    }

    public static <T> FstCondition<T> TRUE() {
        return new FstCondition<T>(){

            @Override
            public boolean test(int index, T obj) {
                return true;
            }
        };
    }

    public static class OrConditon<T>
    implements FstCondition<T> {
        private List<FstCondition<T>> list = Lists.newArrayList();

        public void add(FstCondition<T> condition) {
            this.list.add(condition);
        }

        @Override
        public boolean test(int index, T obj) {
            if (this.list.isEmpty()) {
                return false;
            }
            for (FstCondition<T> condition : this.list) {
                if (!condition.test(index, obj)) continue;
                return true;
            }
            return false;
        }
    }

    public static class AndConditon<T>
    implements FstCondition<T> {
        private List<FstCondition<T>> list = Lists.newArrayList();

        public AndConditon<T> add(FstCondition<T> condition) {
            this.list.add(condition);
            return this;
        }

        @Override
        public boolean test(int index, T obj) {
            if (this.list.isEmpty()) {
                return false;
            }
            for (FstCondition<T> condition : this.list) {
                if (condition.test(index, obj)) continue;
                return false;
            }
            return true;
        }
    }
}

