/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fst;

import com.mayabot.nlp.fst.FST;
import com.mayabot.nlp.fst.FstNode;
import java.util.Optional;

public class FstFounder<T> {
    private FstNode<T> point;
    private FST<T> fst;
    private int start = -1;
    private T startObj;
    private int lastIndex = -1;
    private FoundResult notFound_continue = new FoundResult(true, false, null);

    FstFounder(FST<T> fst) {
        this.fst = fst;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FoundResult<T> input(int index, T currentObj) {
        try {
            Optional<FstNode<T>> go = this.point.transeform(index, currentObj);
            FstNode<T> lastPoint = null;
            if (!go.isPresent()) {
                this.point = this.fst.getStartNode();
                lastPoint = this.fst.getStartNode();
            } else {
                lastPoint = this.point;
                this.point = go.get();
            }
            if (this.point.isStart()) {
                this.reset();
                FoundResult foundResult = this.notFound_continue;
                return foundResult;
            }
            if (this.point.isNormal()) {
                if (lastPoint.isStart()) {
                    this.resetData();
                    this.start = index;
                    this.startObj = currentObj;
                }
                FoundResult foundResult = this.notFound_continue;
                return foundResult;
            }
            boolean includeCurrentObj = this.point.isInclude();
            if (index == Integer.MAX_VALUE) {
                FoundResult result = null;
                if (includeCurrentObj) {
                    result = this.notFound_continue;
                } else {
                    result = new FoundResult(false, true, this.point.getId());
                    result.start = this.start;
                    result.startObj = this.startObj;
                    result.length = this.lastIndex - this.start + 1;
                }
                FoundResult foundResult = result;
                return foundResult;
            }
            FoundResult result = null;
            if (includeCurrentObj) {
                result = new FoundResult(true, true, this.point.getId());
                if (this.start == -1) {
                    this.start = index;
                    this.startObj = currentObj;
                }
                result.start = this.start;
                result.startObj = this.startObj;
                result.length = index - this.start + 1;
            } else if (this.start == -1) {
                result = this.notFound_continue;
            } else {
                result = new FoundResult(false, true, this.point.getId());
                result.start = this.start;
                result.startObj = this.startObj;
                result.length = index - this.start;
            }
            FoundResult foundResult = result;
            return foundResult;
        }
        finally {
            this.lastIndex = index;
        }
    }

    public void reset() {
        this.point = this.fst.getStartNode();
        this.resetData();
    }

    private void resetData() {
        this.start = -1;
        this.startObj = null;
        this.lastIndex = -1;
    }

    public static class FoundResult<T> {
        boolean movieToNext = true;
        boolean found;
        int start;
        T startObj;
        int length;
        String endNodeName;

        public FoundResult(boolean movieToNext, boolean found, String endNodeName) {
            this.movieToNext = movieToNext;
            this.found = found;
            this.endNodeName = endNodeName;
        }

        public boolean isFound() {
            return this.found;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public T getStartObj() {
            return this.startObj;
        }

        public String getEndNodeName() {
            return this.endNodeName;
        }
    }
}

