/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fst;

import com.mayabot.nlp.fst.FST;
import com.mayabot.nlp.fst.FstFounder;
import java.util.Iterator;
import java.util.function.Function;

public class FstMatcher<T, R> {
    FstFounder<T> founder = null;
    int start = -1;
    int length = -1;
    T startObj;
    T endObj;
    String endNodeId;
    Iterator<R> iterator2;
    R[] iteratorData;
    Function<R, T> function;
    int index = -1;
    boolean movieToNext = true;
    private boolean run = true;
    T _preRead = null;
    T _nowRead = null;
    int movePoint = -1;

    FstMatcher(FST<T> fst, Iterable<R> date, Function<R, T> function) {
        this.founder = fst.newFounder();
        this.iterator2 = date.iterator();
        this.function = function;
    }

    FstMatcher(FST<T> fst, Iterable<R> date) {
        this.founder = fst.newFounder();
        this.iterator2 = date.iterator();
        this.function = x -> x;
    }

    FstMatcher(FST<T> fst, R[] date, Function<R, T> function) {
        this.founder = fst.newFounder();
        this.iteratorData = date;
        this.function = function;
    }

    FstMatcher(FST<T> fst, R[] date) {
        this.founder = fst.newFounder();
        this.iteratorData = date;
        this.function = x -> x;
    }

    public boolean find() {
        this.start = -1;
        do {
            boolean isNotMovie = false;
            if (!this.movieToNext) {
                isNotMovie = true;
                this.movieToNext = true;
            } else if (this.iterator2 != null) {
                if (this.iterator2.hasNext()) {
                    ++this.index;
                    this._preRead = this._nowRead;
                    this._nowRead = this.function.apply(this.iterator2.next());
                } else {
                    this.index = Integer.MAX_VALUE;
                    this._preRead = this._nowRead;
                    this._nowRead = null;
                    this.run = false;
                }
            } else {
                ++this.movePoint;
                if (this.movePoint < this.iteratorData.length) {
                    ++this.index;
                    this._preRead = this._nowRead;
                    this._nowRead = this.function.apply(this.iteratorData[this.movePoint]);
                } else {
                    this.index = Integer.MAX_VALUE;
                    this._preRead = this._nowRead;
                    this._nowRead = null;
                    this.run = false;
                }
            }
            FstFounder.FoundResult<T> fr = this.founder.input(this.index, this._nowRead);
            this.movieToNext = fr.movieToNext;
            if (isNotMovie && !this.movieToNext) {
                System.err.println("\u4e0a\u6b21\u662f\u4e0d\u79fb\u52a8\uff0c\u8fd9\u6b21\u8fd8\u662f\u4e0d\u79fb\u52a8\uff0c\u90a3\u4e48\u5c31\u4e0d\u5bf9\u4e86\uff0c\u5f3a\u5236\u79fb\u52a8");
                this.movieToNext = true;
            }
            if (this.index == Integer.MAX_VALUE) {
                this.movieToNext = true;
            }
            if (!fr.found) continue;
            this.start = fr.start;
            this.length = fr.length;
            this.endNodeId = fr.endNodeName;
            this.startObj = fr.startObj;
            this.endObj = fr.movieToNext ? this._nowRead : this._preRead;
            this.founder.reset();
            return true;
        } while (this.run);
        return false;
    }

    public int getStart() {
        return this.start;
    }

    public FstFounder<T> getFounder() {
        return this.founder;
    }

    public int getLength() {
        return this.length;
    }

    public String getEndNodeId() {
        return this.endNodeId;
    }

    public T getStartObj() {
        return this.startObj;
    }

    public T getEndObj() {
        return this.endObj;
    }
}

