/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fst;

import com.mayabot.nlp.fst.FST;
import com.mayabot.nlp.fst.FstCondition;
import com.mayabot.t.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;

public class FstNode<R> {
    private boolean include = false;
    private Type type = Type.START;
    private String id;
    private List<ConditionPair> conditionList = Lists.newArrayList();
    private FST fst;

    public <N> FstNode<R> edge(FstCondition<R> condition, String toNodeId) {
        if (this.isEnd()) {
            throw new RuntimeException("End Node conn't to !!!");
        }
        FstNode to = this.fst.$(toNodeId);
        this.conect(condition, to);
        return to;
    }

    private void conect(FstCondition<R> condition, FstNode<R> node) {
        this.conditionList.add(new ConditionPair<R>(condition, node));
    }

    public <N> FstNode<R> to(String toNodeId, FstCondition<R> condition) {
        return this.edge(condition, toNodeId);
    }

    public void loop(FstCondition<R> condition) {
        this.conect(condition, this);
    }

    public <N> FstNode<R> linkIfReadEndFlag(String toNodeId) {
        return this.to(toNodeId, (x, y) -> x == Integer.MAX_VALUE);
    }

    public Optional<FstNode<R>> transeform(int i, R readObj) {
        for (ConditionPair conditionPair : this.conditionList) {
            boolean accept = conditionPair.testMethod.test(i, readObj);
            if (!accept) continue;
            return Optional.of(conditionPair.to);
        }
        return Optional.empty();
    }

    private FstNode(Type type, String name) {
        this.type = type;
        this.id = name;
    }

    static <T> FstNode<T> createNode(FST fst, String name) {
        return super.fst(fst);
    }

    static <T> FstNode<T> createStartNode(FST fst) {
        return super.fst(fst);
    }

    static <T> FstNode<T> createTerminalNode(FST fst, String name, boolean include) {
        FstNode s = super.fst(fst);
        s.include = include;
        return s;
    }

    public boolean isNormal() {
        return Type.NORMAL.equals((Object)this.type);
    }

    public boolean isStart() {
        return Type.START.equals((Object)this.type);
    }

    public boolean isEnd() {
        return Type.END.equals((Object)this.type);
    }

    public String getId() {
        return this.id;
    }

    public boolean isInclude() {
        return this.include;
    }

    private FstNode<R> fst(FST<R> fst) {
        this.fst = fst;
        return this;
    }

    public static class ConditionPair<T> {
        FstCondition<T> testMethod;
        FstNode<T> to;

        public ConditionPair(FstCondition<T> testMethod, FstNode<T> to) {
            this.testMethod = testMethod;
            this.to = to;
        }
    }

    public static enum Type {
        START,
        NORMAL,
        END;

    }
}

