/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.perceptron;

import com.mayabot.nlp.collection.dat.DoubleArrayTrie;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Labels;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.TopIntMinK;
import com.mayabot.nlp.perceptron.TrainSample;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u0000 G2\u00020\u0001:\u0001GB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0018H\u0016J\u001e\u0010'\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020\"H\u0016J\u001e\u0010,\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020\"H\u0002J\b\u0010\u0002\u001a\u00020\u0003H\u0016J \u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010+\u001a\u00020\"2\u0006\u00101\u001a\u00020\u0005H\u0002J\u0010\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u0005H\u0016J0\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u0002072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0010\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u00020:H\u0016J\u0018\u0010;\u001a\u00020\u00182\u0006\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u00020\u0005H\u0002J\u0010\u0010>\u001a\u00020\u001e2\u0006\u0010/\u001a\u000200H\u0016J&\u0010>\u001a\u00020\u001e2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005J\u0010\u0010?\u001a\u00020\u001e2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u0010@\u001a\u00020\u000b2\u0006\u0010/\u001a\u0002002\u0006\u0010A\u001a\u000207H\u0002J\u0018\u0010B\u001a\u00020\u001e2\u0006\u0010C\u001a\u00020\"2\u0006\u0010D\u001a\u00020\"H\u0002J \u0010E\u001a\u00020\u001e2\u0006\u0010C\u001a\u00020\"2\u0006\u0010D\u001a\u00020\"2\u0006\u0010A\u001a\u000207H\u0002J0\u0010F\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020\"2\u0006\u0010D\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006H"}, d2={"Lcom/mayabot/nlp/perceptron/PerceptronModel;", "Lcom/mayabot/nlp/perceptron/Perceptron;", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "labelCount", "", "(Lcom/mayabot/nlp/perceptron/FeatureSet;I)V", "parameter", "", "(Lcom/mayabot/nlp/perceptron/FeatureSet;I[F)V", "decodeQuickModel", "", "getDecodeQuickModel", "()Z", "setDecodeQuickModel", "(Z)V", "getFeatureSet", "()Lcom/mayabot/nlp/perceptron/FeatureSet;", "setFeatureSet", "(Lcom/mayabot/nlp/perceptron/FeatureSet;)V", "getLabelCount", "()I", "labelLimitInParameter", "maxScore", "", "getParameter", "()[F", "setParameter", "([F)V", "average", "", "total", "", "timestamp", "", "current", "compress", "ratio", "threshold", "decode", "featureSequence", "", "Lcom/mayabot/nlp/hppc/IntArrayList;", "guessLabel", "decodeQuick", "featureToLabel", "Lcom/mayabot/nlp/perceptron/Labels;", "data", "Lcom/mayabot/nlp/perceptron/TrainSample;", "i", "makeSureParameter", "featureId", "record", "index", "value", "", "save", "dir", "Ljava/io/File;", "scoreBase", "featureVector", "currentTag", "update", "updateForOnlineLearn", "updateForOnlineLearnInner", "step", "updateOnline", "goldIndex", "predictIndex", "updateOnline2", "updateParameter", "Companion", "mynlp-perceptron"})
public class PerceptronModel
implements Perceptron {
    private final double maxScore = -2.147483648E9;
    private boolean decodeQuickModel;
    private final int labelLimitInParameter;
    @NotNull
    private FeatureSet featureSet;
    private final int labelCount;
    @NotNull
    private float[] parameter;
    public static final Companion Companion = new Companion(null);

    public final boolean getDecodeQuickModel() {
        return this.decodeQuickModel;
    }

    public final void setDecodeQuickModel(boolean bl) {
        this.decodeQuickModel = bl;
    }

    @Override
    @NotNull
    public FeatureSet featureSet() {
        return this.featureSet;
    }

    @Override
    public void makeSureParameter(int featureId) {
        int newsize = (featureId + 1) * this.labelCount;
        if (newsize > this.parameter.length) {
            float[] fArray = Arrays.copyOf(this.parameter, newsize);
            Intrinsics.checkExpressionValueIsNotNull((Object)fArray, (String)"Arrays.copyOf(parameter, newsize)");
            this.parameter = fArray;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull TrainSample data, @NotNull double[] total, @NotNull int[] timestamp, int current) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)total, (String)"total");
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        int length = data.getSize();
        int[] guessLabel = new int[length];
        this.decode((List<? extends IntArrayList>)data.getFeatureMatrix(), guessLabel);
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            Labels labels = this.featureToLabel(data, guessLabel, (int)i);
            this.updateParameter(labels.getGoldFeature(), labels.getPredFeature(), total, timestamp, current);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(@NotNull TrainSample data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        int length = data.getSize();
        int[] guessLabel = new int[length];
        this.decode((List<? extends IntArrayList>)data.getFeatureMatrix(), guessLabel);
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            Labels labels = this.featureToLabel(data, guessLabel, (int)i);
            this.updateOnline(labels.getGoldFeature(), labels.getPredFeature());
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateForOnlineLearn(@NotNull TrainSample data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        int[] guessLabel = new int[data.getSize()];
        this.decode((List<? extends IntArrayList>)data.getFeatureMatrix(), guessLabel);
        if (Arrays.equals(guessLabel, data.getLabel())) {
            return;
        }
        int over = 0;
        int n = 0;
        int n2 = 10;
        while (n < n2) {
            void i;
            boolean eq = this.updateForOnlineLearnInner(data, 1.0f);
            if (eq && ++over > 1) {
                return;
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean updateForOnlineLearnInner(TrainSample data, float step) {
        int length = data.getSize();
        int[] guessLabel = new int[length];
        this.decode((List<? extends IntArrayList>)data.getFeatureMatrix(), guessLabel);
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            Labels labels = this.featureToLabel(data, guessLabel, (int)i);
            this.updateOnline2(labels.getGoldFeature(), labels.getPredFeature(), step);
            ++i;
        }
        this.decode((List<? extends IntArrayList>)data.getFeatureMatrix(), guessLabel);
        return Arrays.equals(guessLabel, data.getLabel());
    }

    /*
     * WARNING - void declaration
     */
    private final void updateOnline2(int[] goldIndex, int[] predictIndex, float step) {
        int n = 0;
        int n2 = goldIndex.length;
        while (n < n2) {
            void i;
            int xii = predictIndex[i];
            if (goldIndex[i] != xii) {
                int toAdd = goldIndex[i];
                if (toAdd > this.labelLimitInParameter) {
                    int n3 = toAdd;
                    this.parameter[n3] = this.parameter[n3] + step;
                }
                if (xii >= 0 && xii < this.parameter.length && xii > this.labelLimitInParameter) {
                    int n4 = xii;
                    this.parameter[n4] = this.parameter[n4] - step;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateOnline(int[] goldIndex, int[] predictIndex) {
        int n = 0;
        int n2 = goldIndex.length;
        while (n < n2) {
            void i;
            int xii = predictIndex[i];
            if (goldIndex[i] != xii) {
                int n3 = goldIndex[i];
                float f = this.parameter[n3];
                this.parameter[n3] = f + 1.0f;
                if (xii >= 0 && xii < this.parameter.length) {
                    int n4 = xii;
                    f = this.parameter[n4];
                    this.parameter[n4] = f + -1.0f;
                } else {
                    throw (Throwable)new IllegalArgumentException("\u66f4\u65b0\u53c2\u6570\u65f6\u4f20\u5165\u4e86\u975e\u6cd5\u7684\u4e0b\u6807");
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Labels featureToLabel(TrainSample data, int[] guessLabel, int i) {
        IntArrayList featureVector = data.getFeatureMatrix().get(i);
        int[] goldFeature = new int[featureVector.size()];
        int[] predFeature = new int[featureVector.size()];
        int last = featureVector.size() - 1;
        int n = 0;
        int n2 = last;
        while (n < n2) {
            void j;
            goldFeature[j] = featureVector.get((int)j) * this.labelCount + data.getLabel()[i];
            predFeature[j] = featureVector.get((int)j) * this.labelCount + guessLabel[i];
            ++j;
        }
        goldFeature[last] = (i == 0 ? this.labelCount : data.getLabel()[i - 1]) * this.labelCount + data.getLabel()[i];
        predFeature[last] = (i == 0 ? this.labelCount : guessLabel[i - 1]) * this.labelCount + guessLabel[i];
        return new Labels(goldFeature, predFeature);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean updateParameter(int[] goldIndex, int[] predictIndex, double[] total, int[] timestamp, int current) {
        int[] nArray = goldIndex;
        if (Arrays.equals(nArray, predictIndex)) {
            return false;
        }
        int n = 0;
        int n2 = goldIndex.length;
        while (n < n2) {
            void i;
            if (goldIndex[i] != predictIndex[i]) {
                this.record(goldIndex[i], 1.0f, total, timestamp, current);
                if (predictIndex[i] >= 0 && predictIndex[i] < this.parameter.length) {
                    this.record(predictIndex[i], -1.0f, total, timestamp, current);
                } else {
                    throw (Throwable)new IllegalArgumentException("\u66f4\u65b0\u53c2\u6570\u65f6\u4f20\u5165\u4e86\u975e\u6cd5\u7684\u4e0b\u6807");
                }
            }
            ++i;
        }
        return true;
    }

    private final void record(int index, float value, double[] total, int[] timestamp, int current) {
        int passed = current - timestamp[index];
        int n = index;
        total[n] = total[n] + (double)passed * (double)this.parameter[index];
        int n2 = index;
        this.parameter[n2] = this.parameter[n2] + value;
        timestamp[index] = current;
    }

    /*
     * WARNING - void declaration
     */
    public final void average(@NotNull double[] total, @NotNull int[] timestamp, int current) {
        Intrinsics.checkParameterIsNotNull((Object)total, (String)"total");
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        float cf = current;
        int n = 0;
        int n2 = this.parameter.length;
        while (n < n2) {
            void i;
            float pass = cf - (float)timestamp[i];
            float totali = (float)total[i];
            this.parameter[i] = (totali + pass * this.parameter[i]) / cf;
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void compress(double ratio, double threshold) {
        Object object;
        Object object2;
        Object heap;
        boolean bl;
        if (ratio < 0.0 || ratio >= 1.0) {
            throw (Throwable)new IllegalArgumentException("\u538b\u7f29\u6bd4\u5fc5\u987b\u4ecb\u4e8e 0 \u548c 1 \u4e4b\u95f4");
        }
        boolean bl2 = bl = this.featureSet.getKeys() != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int k = ratio == 0.0 ? 0 : (int)(ratio * (double)this.featureSet.size());
        List<String> list = this.featureSet.getKeys();
        if (list == null) {
            Intrinsics.throwNpe();
        }
        List<String> featureList = list;
        Function1<Integer, Float> score$ = new Function1<Integer, Float>(this){
            final /* synthetic */ PerceptronModel this$0;

            /*
             * WARNING - void declaration
             */
            public final float invoke(int id) {
                float s = 0.0f;
                int n = id * this.this$0.getLabelCount();
                int n2 = id * this.this$0.getLabelCount() + this.this$0.getLabelCount();
                while (n < n2) {
                    void i;
                    s += Math.abs(this.this$0.getParameter()[i]);
                    ++i;
                }
                return s;
            }
            {
                this.this$0 = perceptronModel;
                super(1);
            }
        };
        HashSet<Integer> filterSet = new HashSet<Integer>();
        int n = 0;
        int n2 = featureList.size();
        while (n < n2) {
            void id;
            float s = score$.invoke((int)id);
            if ((double)s < threshold) {
                filterSet.add((int)id);
            }
            ++id;
        }
        String id = "threshold filterd " + filterSet.size();
        System.out.println((Object)id);
        if (k > 0 && filterSet.size() < k) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            heap = new TopIntMinK(k - filterSet.size());
            String string = "let's filter top min " + (k - filterSet.size());
            System.out.println((Object)string);
            int n3 = 0;
            int s = featureList.size();
            while (n3 < s) {
                void id2;
                float s2 = score$.invoke((int)id2);
                if ((double)s2 >= threshold) {
                    ((TopIntMinK)heap).push((int)id2, s2);
                }
                ++id2;
            }
            Iterable s2 = $receiver$iv = (Iterable)((TopIntMinK)heap).result();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl3 = false;
                object = ((Number)it.getFirst()).intValue();
                object2.add(object);
            }
            Set topMinResultIdSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            filterSet.addAll(topMinResultIdSet);
        }
        heap = StringCompanionObject.INSTANCE;
        String topMinResultIdSet = "%.3f";
        Object[] $receiver$iv = new Object[]{Float.valueOf((float)filterSet.size() * 1.0f / (float)featureList.size())};
        object2 = new StringBuilder().append("remove ").append(filterSet.size()).append(" feature,real compress ");
        String string = String.format(topMinResultIdSet, Arrays.copyOf($receiver$iv, $receiver$iv.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
        object = string;
        heap = ((StringBuilder)object2).append((String)object).toString();
        System.out.println(heap);
        int newSize = featureList.size() - filterSet.size();
        ArrayList newFeatureList = new ArrayList(newSize);
        float[] newParameter = new float[this.labelCount * newSize];
        int cc = 0;
        Iterable $receiver$iv2 = featureList;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv2) {
            void s;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n5 = n4;
            String $i$f$map = (String)item$iv;
            int index = n5;
            boolean bl4 = false;
            if (index > this.labelCount && filterSet.contains(index)) continue;
            Collection collection = newFeatureList;
            collection.add(s);
            System.arraycopy(this.parameter, index * this.labelCount, newParameter, cc * this.labelCount, this.labelCount);
            int n6 = cc;
            cc = n6 + 1;
        }
        this.parameter = newParameter;
        this.featureSet = new FeatureSet(new DoubleArrayTrie(newFeatureList), newFeatureList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        dir.mkdirs();
        Object object = new File(dir, "parameter.bin");
        object = new FileOutputStream((File)object);
        int n = 8192;
        object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
        Throwable throwable = null;
        try {
            float[] $receiver$iv;
            BufferedOutputStream it = (BufferedOutputStream)object;
            boolean bl = false;
            DataOutputStream dout = new DataOutputStream(it);
            dout.writeInt(this.labelCount);
            dout.writeInt(this.parameter.length);
            float[] fArray = $receiver$iv = this.parameter;
            int n2 = fArray.length;
            for (int i = 0; i < n2; ++i) {
                float element$iv;
                float w = element$iv = fArray[i];
                boolean bl2 = false;
                dout.writeFloat(w);
            }
            dout.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        this.featureSet.save(new File(dir, "feature.dat"), new File(dir, "feature.txt"));
    }

    /*
     * WARNING - void declaration
     */
    private final void decodeQuick(List<? extends IntArrayList> featureSequence, int[] guessLabel) {
        int index = 0;
        for (IntArrayList intArrayList : featureSequence) {
            int[] buffer = intArrayList.buffer;
            int sizeM1 = intArrayList.size() - 1;
            double maxScore = this.maxScore;
            int maxIndex = 0;
            int n = 0;
            int n2 = this.labelCount;
            while (n < n2) {
                void label;
                double score = 0.0;
                int n3 = 0;
                int n4 = sizeM1;
                while (n3 < n4) {
                    void i;
                    score += (double)this.parameter[buffer[i] * this.labelCount + label];
                    ++i;
                }
                if (score > maxScore) {
                    maxIndex = label;
                    maxScore = score;
                }
                ++label;
            }
            guessLabel[index++] = maxIndex;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void decode(@NotNull List<? extends IntArrayList> featureSequence, @NotNull int[] guessLabel) {
        int base;
        int j;
        Intrinsics.checkParameterIsNotNull(featureSequence, (String)"featureSequence");
        Intrinsics.checkParameterIsNotNull((Object)guessLabel, (String)"guessLabel");
        if (this.decodeQuickModel) {
            this.decodeQuick(featureSequence, guessLabel);
            return;
        }
        int sentenceLength = featureSequence.size();
        int[] preMatrix = new int[sentenceLength * this.labelCount];
        double[] scoreMLast = new double[this.labelCount];
        double[] scoreMNow = new double[this.labelCount];
        IntArrayList firstFeature = featureSequence.get(0);
        int bos = this.labelCount;
        int bosBase = bos * this.labelCount;
        int n = 0;
        int n2 = this.labelCount;
        while (n < n2) {
            double score;
            preMatrix[j] = j;
            scoreMLast[j] = score = this.scoreBase(firstFeature, j) + (double)this.parameter[bosBase + j];
            ++j;
        }
        j = 1;
        n2 = sentenceLength;
        while (j < n2) {
            void i;
            IntArrayList allFeature = featureSequence.get((int)i);
            base = i * this.labelCount;
            int n3 = 0;
            int n4 = this.labelCount;
            while (n3 < n4) {
                void curLabel;
                double maxScore = this.maxScore;
                double baseScore = this.scoreBase(allFeature, (int)curLabel);
                int n5 = 0;
                int n6 = this.labelCount;
                while (n5 < n6) {
                    void preLabel;
                    double curScore = scoreMLast[preLabel] + baseScore + (double)this.parameter[preLabel * this.labelCount + curLabel];
                    if (curScore > maxScore) {
                        maxScore = curScore;
                        preMatrix[base + curLabel] = preLabel;
                        scoreMNow[curLabel] = maxScore;
                    }
                    ++preLabel;
                }
                ++curLabel;
            }
            double[] temp = scoreMLast;
            scoreMLast = scoreMNow;
            scoreMNow = temp;
            ++i;
        }
        int maxIndex = 0;
        double maxScore = scoreMLast[0];
        base = 1;
        int temp = this.labelCount;
        while (base < temp) {
            void index;
            double x = scoreMLast[index];
            if (maxScore < x) {
                maxIndex = index;
                maxScore = x;
            }
            ++index;
        }
        int k = (sentenceLength - 1) * this.labelCount;
        temp = sentenceLength - 1;
        boolean bl = false;
        while (temp >= 0) {
            void i;
            guessLabel[i] = maxIndex;
            maxIndex = preMatrix[k + maxIndex];
            k -= this.labelCount;
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final double scoreBase(IntArrayList featureVector, int currentTag) {
        double score = 0.0;
        int[] buffer = featureVector.buffer;
        int n = 0;
        int n2 = featureVector.size() - 1;
        while (n < n2) {
            void i;
            int index = buffer[i];
            score += (double)this.parameter[index * this.labelCount + currentTag];
            ++i;
        }
        return score;
    }

    @NotNull
    public final FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public final void setFeatureSet(@NotNull FeatureSet featureSet) {
        Intrinsics.checkParameterIsNotNull((Object)featureSet, (String)"<set-?>");
        this.featureSet = featureSet;
    }

    public final int getLabelCount() {
        return this.labelCount;
    }

    @NotNull
    public final float[] getParameter() {
        return this.parameter;
    }

    public final void setParameter(@NotNull float[] fArray) {
        Intrinsics.checkParameterIsNotNull((Object)fArray, (String)"<set-?>");
        this.parameter = fArray;
    }

    public PerceptronModel(@NotNull FeatureSet featureSet, int labelCount, @NotNull float[] parameter) {
        Intrinsics.checkParameterIsNotNull((Object)featureSet, (String)"featureSet");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        this.featureSet = featureSet;
        this.labelCount = labelCount;
        this.parameter = parameter;
        this.maxScore = Integer.MIN_VALUE;
        this.labelLimitInParameter = (this.labelCount + 1) * this.labelCount;
    }

    public PerceptronModel(@NotNull FeatureSet featureSet, int labelCount) {
        Intrinsics.checkParameterIsNotNull((Object)featureSet, (String)"featureSet");
        this(featureSet, labelCount, new float[featureSet.size() * labelCount]);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0006J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/mayabot/nlp/perceptron/PerceptronModel$Companion;", "", "()V", "load", "Lcom/mayabot/nlp/perceptron/PerceptronModel;", "dir", "Ljava/io/File;", "parameterFile", "featureBin", "featureText", "parameterBin", "Ljava/io/InputStream;", "featureDat", "", "mynlp-perceptron"})
    public static final class Companion {
        @NotNull
        public final PerceptronModel load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, boolean featureDat) {
            Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
            Intrinsics.checkParameterIsNotNull((Object)featureBin, (String)"featureBin");
            return featureDat ? this.load(parameterBin, featureBin, null) : this.load(parameterBin, null, featureBin);
        }

        @NotNull
        public final PerceptronModel load(@NotNull File parameterFile, @Nullable File featureBin, @Nullable File featureText) {
            InputStream inputStream;
            InputStream inputStream2;
            InputStream inputStream3;
            Intrinsics.checkParameterIsNotNull((Object)parameterFile, (String)"parameterFile");
            Object object = parameterFile;
            Companion companion = this;
            InputStream inputStream4 = new FileInputStream((File)object);
            object = inputStream4;
            int n = 8192;
            inputStream4 = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Companion companion2 = companion;
            InputStream inputStream5 = inputStream4;
            File file = featureBin;
            if (file != null) {
                object = file;
                inputStream4 = inputStream5;
                companion = companion2;
                inputStream3 = new FileInputStream((File)object);
                object = inputStream3;
                n = 8192;
                inputStream3 = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
                companion2 = companion;
                inputStream5 = inputStream4;
                inputStream2 = inputStream3;
            } else {
                inputStream2 = null;
            }
            InputStream inputStream6 = inputStream2;
            File file2 = featureText;
            if (file2 != null) {
                object = file2;
                inputStream3 = inputStream6;
                inputStream4 = inputStream5;
                companion = companion2;
                InputStream inputStream7 = new FileInputStream((File)object);
                object = inputStream7;
                n = 8192;
                inputStream7 = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
                companion2 = companion;
                inputStream5 = inputStream4;
                inputStream6 = inputStream3;
                inputStream = inputStream7;
            } else {
                inputStream = null;
            }
            return companion2.load(inputStream5, inputStream6, inputStream);
        }

        @NotNull
        public final PerceptronModel load(@NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Function1<String, File> loadIfExit$ = new Function1<String, File>(dir){
                final /* synthetic */ File $dir;

                @Nullable
                public final File invoke(@NotNull String fname) {
                    Intrinsics.checkParameterIsNotNull((Object)fname, (String)"fname");
                    File f = new File(this.$dir, fname);
                    return f.exists() ? f : null;
                }
                {
                    this.$dir = file;
                    super(1);
                }
            };
            return this.load(new File(dir, "parameter.bin"), loadIfExit$.invoke("feature.dat"), loadIfExit$.invoke("feature.txt"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final PerceptronModel load(@NotNull InputStream parameterBin, @Nullable InputStream featureBin, @Nullable InputStream featureText) {
            FeatureSet featureSet;
            Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
            int labelCount = 0;
            float[] parameter = new float[]{};
            Closeable closeable = parameterBin;
            Throwable throwable = null;
            try {
                int n;
                InputStream x = (InputStream)closeable;
                boolean bl = false;
                DataInputStream input = new DataInputStream(x);
                labelCount = input.readInt();
                int pSize = input.readInt();
                parameter = new float[pSize];
                byte[] buffer = new byte[16384];
                ByteBuffer wrap = ByteBuffer.wrap(buffer);
                int point = 0;
                while ((n = input.read(buffer)) != -1) {
                    if (n % 4 != 0) {
                        String string = "Error Size";
                        System.out.println((Object)string);
                        System.exit(0);
                    }
                    wrap.flip();
                    wrap.limit(n);
                    int n2 = 0;
                    int n3 = n / 4;
                    while (n2 < n3) {
                        void i;
                        int n4 = point++;
                        ByteBuffer byteBuffer = wrap;
                        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"wrap");
                        parameter[n4] = byteBuffer.getFloat();
                        ++i;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (featureBin != null) {
                featureSet = featureText != null ? FeatureSet.Companion.read(featureBin, featureText) : FeatureSet.Companion.read(featureBin);
            } else if (featureText != null) {
                featureSet = FeatureSet.Companion.read(featureText);
            } else {
                throw (Throwable)new RuntimeException();
            }
            FeatureSet fs = featureSet;
            return new PerceptronModel(fs, labelCount, parameter);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

