/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.perceptron;

import com.mayabot.nlp.perceptron.EvaluateRunner;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronModel;
import com.mayabot.nlp.perceptron.TrainSample;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0007J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/mayabot/nlp/perceptron/PerceptronTrainer;", "", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "labelCount", "", "trainSource", "", "Lcom/mayabot/nlp/perceptron/TrainSample;", "evaluateScript", "Lcom/mayabot/nlp/perceptron/EvaluateRunner;", "maxIter", "decodeQuickModel_", "", "(Lcom/mayabot/nlp/perceptron/FeatureSet;ILjava/util/List;Lcom/mayabot/nlp/perceptron/EvaluateRunner;IZ)V", "buildPerceptronModel", "Lcom/mayabot/nlp/perceptron/PerceptronModel;", "parameter", "", "train", "Lcom/mayabot/nlp/perceptron/Perceptron;", "threadNumber", "trainOneThread", "trainParallel", "mynlp-perceptron"})
public final class PerceptronTrainer {
    private final FeatureSet featureSet;
    private final int labelCount;
    private final List<TrainSample> trainSource;
    private final EvaluateRunner evaluateScript;
    private final int maxIter;
    private final boolean decodeQuickModel_;

    private final PerceptronModel buildPerceptronModel(FeatureSet featureSet, int labelCount) {
        PerceptronModel perceptronModel;
        PerceptronModel $receiver = perceptronModel = new PerceptronModel(featureSet, labelCount);
        boolean bl = false;
        $receiver.setDecodeQuickModel(this.decodeQuickModel_);
        return perceptronModel;
    }

    private final PerceptronModel buildPerceptronModel(FeatureSet featureSet, int labelCount, float[] parameter) {
        PerceptronModel perceptronModel;
        PerceptronModel $receiver = perceptronModel = new PerceptronModel(featureSet, labelCount, parameter);
        boolean bl = false;
        $receiver.setDecodeQuickModel(this.decodeQuickModel_);
        return perceptronModel;
    }

    @JvmOverloads
    @NotNull
    public final Perceptron train(int threadNumber) {
        return threadNumber == 1 ? this.trainOneThread() : this.trainParallel(threadNumber);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Perceptron train$default(PerceptronTrainer perceptronTrainer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Runtime.getRuntime().availableProcessors() - 1;
        }
        return perceptronTrainer.train(n);
    }

    @JvmOverloads
    @NotNull
    public final Perceptron train() {
        return PerceptronTrainer.train$default(this, 0, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Perceptron trainOneThread() {
        PerceptronModel model = this.buildPerceptronModel(this.featureSet, this.labelCount);
        double[] total = new double[model.getParameter().length];
        int[] timestamp = new int[model.getParameter().length];
        int current = 0;
        int n = 1;
        int n2 = this.maxIter;
        if (n <= n2) {
            while (true) {
                Object element$iv2;
                void k;
                long t1 = System.currentTimeMillis();
                String string = "\n#ITER " + (int)k + '/' + this.maxIter;
                System.out.println((Object)string);
                System.out.print("Process 0%");
                int per = 0;
                Iterable $receiver$iv = this.trainSource;
                for (Object element$iv2 : $receiver$iv) {
                    String string2;
                    TrainSample it = (TrainSample)element$iv2;
                    boolean bl = false;
                    int n3 = current;
                    current = n3 + 1;
                    model.update(it, total, timestamp, current);
                    n3 = per;
                    if ((per = n3 + 1) % 5000 != 0) continue;
                    String string3 = "%.2f";
                    Object[] objectArray = new Object[]{(double)per * 100.0 / (double)this.trainSource.size()};
                    StringBuilder stringBuilder = new StringBuilder().append("\rProcess ");
                    PrintStream printStream = System.out;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                    printStream.print(stringBuilder.append(string2).append('%').toString());
                }
                System.out.print("\r");
                long t2 = System.currentTimeMillis();
                element$iv2 = "train use " + (t2 - t1) + " ms\n";
                System.out.println(element$iv2);
                float[] back = Arrays.copyOf(model.getParameter(), model.getParameter().length);
                model.average(total, timestamp, current);
                this.evaluateScript.run((int)k, model);
                Intrinsics.checkExpressionValueIsNotNull((Object)back, (String)"back");
                model.setParameter(back);
                if (k == n2) break;
                ++k;
            }
        }
        model.average(total, timestamp, current);
        return model;
    }

    /*
     * WARNING - void declaration
     */
    private final Perceptron trainParallel(int threadNumber) {
        int n;
        Object[] result$iv = new PerceptronModel[threadNumber];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            PerceptronModel perceptronModel;
            void i$iv;
            n = i$iv;
            void var17_7 = i$iv++;
            Object[] objectArray = result$iv;
            boolean bl = false;
            objectArray[var17_7] = perceptronModel = this.buildPerceptronModel(this.featureSet, this.labelCount);
        }
        Object[] modelArray = result$iv;
        ExecutorService executor = Executors.newFixedThreadPool(threadNumber);
        List parts = CollectionsKt.chunked((Iterable)this.trainSource, (int)((int)((double)this.trainSource.size() * 1.0 / (double)threadNumber) + 1));
        n3 = 1;
        n = this.maxIter;
        if (n3 <= n) {
            while (true) {
                int i;
                void k;
                String bl = "#ITER " + (int)k + '/' + this.maxIter;
                System.out.println((Object)bl);
                long t1 = System.currentTimeMillis();
                CountDownLatch countDownLatch = new CountDownLatch(threadNumber);
                int n4 = 0;
                int n5 = threadNumber;
                while (n4 < n5) {
                    void s;
                    executor.submit(new Runnable(parts, (int)s, (PerceptronModel[])modelArray, countDownLatch){
                        final /* synthetic */ List $parts;
                        final /* synthetic */ int $s;
                        final /* synthetic */ PerceptronModel[] $modelArray;
                        final /* synthetic */ CountDownLatch $countDownLatch;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            try {
                                List list = (List)this.$parts.get(this.$s);
                                int count = 0;
                                if (this.$s == 0) {
                                    System.out.print("Process 0%");
                                }
                                Iterable $receiver$iv = list;
                                for (T element$iv : $receiver$iv) {
                                    String string;
                                    TrainSample d = (TrainSample)element$iv;
                                    boolean bl = false;
                                    this.$modelArray[this.$s].update(d);
                                    int n = count;
                                    count = n + 1;
                                    if (this.$s != 0 || count % 5000 != 0) continue;
                                    String string2 = "%.2f";
                                    Object[] objectArray = new Object[]{(double)count * 100.0 / (double)list.size()};
                                    StringBuilder stringBuilder = new StringBuilder().append("\rProcess ");
                                    PrintStream printStream = System.out;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                                    printStream.print(stringBuilder.append(string).append('%').toString());
                                }
                                if (this.$s == 0) {
                                    System.out.print("\r");
                                }
                            }
                            finally {
                                this.$countDownLatch.countDown();
                            }
                        }
                        {
                            this.$parts = list;
                            this.$s = n;
                            this.$modelArray = perceptronModelArray;
                            this.$countDownLatch = countDownLatch;
                        }
                    });
                    ++s;
                }
                countDownLatch.await();
                float[] first = ((PerceptronModel)ArraysKt.first((Object[])modelArray)).getParameter();
                n5 = 1;
                int n6 = modelArray.length;
                while (n5 < n6) {
                    float[] the = ((PerceptronModel)modelArray[i]).getParameter();
                    int n7 = 0;
                    int n8 = first.length;
                    while (n7 < n8) {
                        void j;
                        void v0 = j;
                        first[v0] = first[v0] + the[j];
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                n6 = first.length;
                while (i < n6) {
                    void j;
                    first[j] = first[j] / (float)modelArray.length;
                    ++j;
                }
                long t2 = System.currentTimeMillis();
                String string = "use " + (t2 - t1) + " ms\n";
                System.out.println((Object)string);
                this.evaluateScript.run((int)k, (Perceptron)ArraysKt.first((Object[])modelArray));
                if (k == n) break;
                ++k;
            }
        }
        executor.shutdownNow();
        return this.buildPerceptronModel(this.featureSet, this.labelCount, ((PerceptronModel)ArraysKt.first((Object[])modelArray)).getParameter());
    }

    public PerceptronTrainer(@NotNull FeatureSet featureSet, int labelCount, @NotNull List<TrainSample> trainSource, @NotNull EvaluateRunner evaluateScript, int maxIter, boolean decodeQuickModel_) {
        Intrinsics.checkParameterIsNotNull((Object)featureSet, (String)"featureSet");
        Intrinsics.checkParameterIsNotNull(trainSource, (String)"trainSource");
        Intrinsics.checkParameterIsNotNull((Object)evaluateScript, (String)"evaluateScript");
        this.featureSet = featureSet;
        this.labelCount = labelCount;
        this.trainSource = trainSource;
        this.evaluateScript = evaluateScript;
        this.maxIter = maxIter;
        this.decodeQuickModel_ = decodeQuickModel_;
    }
}

