/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.perceptron.solution.ner;

import com.mayabot.nlp.perceptron.solution.ner.NERPerceptron;
import com.mayabot.nlp.perceptron.solution.ner.NerSamples;
import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.common.PerceptronUtilsKt;
import com.mayabot.nlp.segment.common.PkuWord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J6\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u0014"}, d2={"Lcom/mayabot/nlp/perceptron/solution/ner/NEREvaluateUtils;", "", "()V", "combineNER", "", "", "nerArray", "", "evaluateNER", "", "", "recognizer", "Lcom/mayabot/nlp/perceptron/solution/ner/NERPerceptron;", "evaluateData", "targetPos", "posOf", "label", "printNERScore", "", "scores", "mynlp-segment"})
public final class NEREvaluateUtils {
    public static final NEREvaluateUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, double[]> evaluateNER(@NotNull NERPerceptron recognizer, @NotNull List<String> evaluateData, @NotNull Set<String> targetPos) {
        Intrinsics.checkParameterIsNotNull((Object)recognizer, (String)"recognizer");
        Intrinsics.checkParameterIsNotNull(evaluateData, (String)"evaluateData");
        Intrinsics.checkParameterIsNotNull(targetPos, (String)"targetPos");
        TreeMap scores = new TreeMap();
        double[] avg = new double[]{0.0, 0.0, 0.0};
        Map map = scores;
        Iterator iterator = "avg.";
        double[] dArray = avg;
        map.put(iterator, dArray);
        for (String line : evaluateData) {
            Object s;
            String type;
            Object thisCollection$iv;
            CharSequence charSequence;
            ListIterator iterator$iv;
            Collection $receiver$iv;
            Object item$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv2;
            String string;
            Collection<String> collection;
            Object object;
            Object item$iv$iv22;
            Iterable $receiver$iv$iv2;
            void $receiver$iv3;
            List<PkuWord> sentence = PerceptronUtilsKt.parseToWords(line);
            List<WordTerm> sentenceWordTerm = NerSamples.Companion.convert(sentence, targetPos);
            Iterable iterable = sentenceWordTerm;
            NEREvaluateUtils nEREvaluateUtils = this;
            void var12_12 = $receiver$iv3;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv22 : $receiver$iv$iv2) {
                void it;
                object = (WordTerm)item$iv$iv22;
                collection = destination$iv$iv;
                boolean bl = false;
                string = it.getCustomFlag();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            Set<String> gold = nEREvaluateUtils.combineNER(CollectionsKt.toList((Iterable)collection));
            recognizer.decode(sentenceWordTerm);
            $receiver$iv$iv2 = sentenceWordTerm;
            nEREvaluateUtils = this;
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            item$iv$iv22 = $receiver$iv$iv.iterator();
            while (item$iv$iv22.hasNext()) {
                void it;
                item$iv$iv = item$iv$iv22.next();
                WordTerm bl = (WordTerm)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                string = it.getCustomFlag();
                collection.add(string);
            }
            collection = (List)destination$iv$iv2;
            Set<String> pred = nEREvaluateUtils.combineNER((List<String>)collection);
            for (String p : pred) {
                List list;
                item$iv$iv22 = p;
                item$iv$iv = "\t";
                item$iv$iv = new Regex(item$iv$iv);
                int it = 0;
                item$iv$iv22 = item$iv$iv.split((CharSequence)item$iv$iv22, it);
                if (!$receiver$iv.isEmpty()) {
                    iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it2 = (String)iterator$iv.previous();
                        boolean bl = false;
                        charSequence = it2;
                        if (charSequence.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $receiver$iv = list;
                if ($receiver$iv == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                type = stringArray[2];
                s = (double[])scores.get(type);
                if (s == null) {
                    s = new double[]{0.0, 0.0, 0.0};
                    thisCollection$iv = scores;
                    Object $i$f$toTypedArray = s;
                    thisCollection$iv.put(type, $i$f$toTypedArray);
                }
                if (gold.contains(p)) {
                    Object object2 = s;
                    object2[2] = object2[2] + 1.0;
                    Object cfr_ignored_0 = object2[2];
                    double[] dArray2 = avg;
                    dArray2[2] = dArray2[2] + 1.0;
                    double cfr_ignored_1 = avg[2];
                }
                Object object3 = s;
                object3[0] = object3[0] + 1.0;
                Object cfr_ignored_2 = object3[0];
                double[] dArray3 = avg;
                dArray3[0] = dArray3[0] + 1.0;
                double cfr_ignored_3 = avg[0];
            }
            for (String g : gold) {
                List list;
                s = g;
                thisCollection$iv = "\t";
                thisCollection$iv = new Regex((String)thisCollection$iv);
                int $i$f$toTypedArray = 0;
                s = thisCollection$iv.split((CharSequence)s, $i$f$toTypedArray);
                if (!$receiver$iv.isEmpty()) {
                    iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        charSequence = it;
                        if (charSequence.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $receiver$iv = list;
                Collection collection2 = $receiver$iv;
                if (collection2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                thisCollection$iv = collection2;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                type = stringArray[2];
                s = (double[])scores.get(type);
                if (s == null) {
                    s = new double[]{0.0, 0.0, 0.0};
                    object = scores;
                    Object object4 = s;
                    object.put(type, object4);
                }
                Object object5 = s;
                object5[1] = object5[1] + 1.0;
                Object cfr_ignored_4 = object5[1];
                double[] dArray4 = avg;
                dArray4[1] = dArray4[1] + 1.0;
                double cfr_ignored_5 = avg[1];
            }
        }
        for (double[] s : scores.values()) {
            if (s[2] == 0.0) {
                s[0] = 0.0;
                s[1] = 0.0;
                continue;
            }
            s[1] = s[2] / s[1] * (double)100;
            s[0] = s[2] / s[0] * (double)100;
            s[2] = 2.0 * s[0] * s[1] / (s[0] + s[1]);
        }
        this.printNERScore(scores);
        return scores;
    }

    public final void printNERScore(@NotNull Map<String, double[]> scores) {
        Intrinsics.checkParameterIsNotNull(scores, (String)"scores");
        System.out.printf("%4s\t%6s\t%6s\t%6s\n", "NER", "P", "R", "F1");
        Map<String, double[]> map = scores;
        Iterator<Map.Entry<String, double[]>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, double[]> entry;
            Map.Entry<String, double[]> entry2 = entry = iterator.next();
            String type = entry2.getKey();
            entry2 = entry;
            double[] s = entry2.getValue();
            System.out.printf("%4s\t%6.2f\t%6.2f\t%6.2f\n", type, s[0], s[1], s[2]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> combineNER(@NotNull List<String> nerArray) {
        String string;
        LinkedHashSet<String> linkedHashSet;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull(nerArray, (String)"nerArray");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        int begin = 0;
        String prePos = this.posOf(nerArray.get(0));
        int n = 1;
        int n2 = nerArray.size();
        while (n < n2) {
            void i;
            if (nerArray.get((int)i).charAt(0) == 'B' || nerArray.get((int)i).charAt(0) == 'S' || nerArray.get((int)i).charAt(0) == 'O') {
                if (i - begin > true) {
                    objectArray = StringCompanionObject.INSTANCE;
                    String string2 = "%d\t%d\t%s";
                    Object[] objectArray2 = new Object[]{begin, (int)i, prePos};
                    linkedHashSet = result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
                    linkedHashSet.add(string);
                }
                begin = i;
            }
            prePos = this.posOf(nerArray.get((int)i));
            ++i;
        }
        if (nerArray.size() - 1 - begin > 1) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%d\t%d\t%s";
            objectArray = new Object[]{begin, nerArray.size(), prePos};
            linkedHashSet = result;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            string = string4;
            linkedHashSet.add(string);
        }
        return result;
    }

    private final String posOf(String label) {
        String string;
        int index = StringsKt.indexOf$default((CharSequence)label, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            string = label;
        } else {
            String string2 = label;
            int n = index + 1;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    private NEREvaluateUtils() {
    }

    static {
        NEREvaluateUtils nEREvaluateUtils;
        INSTANCE = nEREvaluateUtils = new NEREvaluateUtils();
    }
}

