/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.perceptron.solution.ner;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronModel;
import com.mayabot.nlp.perceptron.solution.ner.NERPerceptronFeature;
import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.t.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/mayabot/nlp/perceptron/solution/ner/NERPerceptron;", "", "model", "Lcom/mayabot/nlp/perceptron/Perceptron;", "labels", "", "", "(Lcom/mayabot/nlp/perceptron/Perceptron;Ljava/util/List;)V", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "kotlin.jvm.PlatformType", "getModel", "()Lcom/mayabot/nlp/perceptron/Perceptron;", "decode", "", "sentence", "Lcom/mayabot/nlp/segment/WordTerm;", "decodeVertexList", "Lcom/mayabot/nlp/segment/wordnet/Vertex;", "save", "dir", "Ljava/io/File;", "Companion", "mynlp-segment"})
public final class NERPerceptron {
    private final FeatureSet featureSet;
    @NotNull
    private final Perceptron model;
    private final List<String> labels;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void decode(@NotNull List<WordTerm> sentence) {
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        FastStringBuilder buffer = new FastStringBuilder(100);
        ArrayList featureList = new ArrayList(sentence.size());
        int n = 0;
        int n2 = sentence.size();
        while (n < n2) {
            void i;
            Collection collection = featureList;
            FeatureSet featureSet = this.featureSet;
            Intrinsics.checkExpressionValueIsNotNull((Object)featureSet, (String)"featureSet");
            IntArrayList intArrayList = NERPerceptronFeature.INSTANCE.extractFeatureVector(sentence, (int)i, featureSet, buffer);
            collection.add(intArrayList);
            ++i;
        }
        int[] result = this.model.decode(featureList);
        n2 = 0;
        int n3 = sentence.size();
        while (n2 < n3) {
            void i;
            sentence.get((int)i).setCustomFlag(this.labels.get(result[i]));
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> decodeVertexList(@NotNull List<? extends Vertex> sentence) {
        Object object;
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        FastStringBuilder buffer = new FastStringBuilder(100);
        ArrayList result = Lists.newArrayListWithExpectedSize(sentence.size());
        ArrayList featureList = new ArrayList(sentence.size());
        int n = 0;
        int n2 = sentence.size();
        while (n < n2) {
            void i;
            Collection collection = featureList;
            FeatureSet featureSet = this.featureSet;
            Intrinsics.checkExpressionValueIsNotNull((Object)featureSet, (String)"featureSet");
            object = NERPerceptronFeature.INSTANCE.extractFeatureVector(sentence, (int)i, featureSet, buffer);
            collection.add(object);
            ++i;
        }
        int[] result2 = this.model.decode(featureList);
        n2 = 0;
        int n3 = sentence.size();
        while (n2 < n3) {
            void i;
            object = result;
            String string = this.labels.get(result2[i]);
            object.add(string);
            ++i;
        }
        ArrayList arrayList = result;
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"result");
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        dir.mkdirs();
        this.model.save(dir);
        Object object = new File(dir, "label.txt");
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        Iterator iterator = object3;
        iterator = new FileOutputStream((File)((Object)iterator));
        object3 = new OutputStreamWriter((OutputStream)((Object)iterator), (Charset)object2);
        BufferedWriter out = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object = out;
        object2 = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl = false;
            Iterable $receiver$iv = this.labels;
            for (Object element$iv : $receiver$iv) {
                String label = (String)element$iv;
                boolean bl2 = false;
                out.write(label + "\n");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    @NotNull
    public final Perceptron getModel() {
        return this.model;
    }

    public NERPerceptron(@NotNull Perceptron model, @NotNull List<String> labels) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(labels, (String)"labels");
        this.model = model;
        this.labels = labels;
        this.featureSet = this.model.featureSet();
    }

    @JvmStatic
    @NotNull
    public static final NERPerceptron load(@NotNull File dir) {
        return Companion.load(dir);
    }

    @JvmStatic
    @NotNull
    public static final NERPerceptron load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, @NotNull InputStream labelText) {
        return Companion.load(parameterBin, featureBin, labelText);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/mayabot/nlp/perceptron/solution/ner/NERPerceptron$Companion;", "", "()V", "load", "Lcom/mayabot/nlp/perceptron/solution/ner/NERPerceptron;", "dir", "Ljava/io/File;", "parameterBin", "Ljava/io/InputStream;", "featureBin", "labelText", "mynlp-segment"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final NERPerceptron load(@NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Object object = new File(dir, "parameter.bin");
            object = new FileInputStream((File)object);
            int n = 8192;
            BufferedInputStream parameterBin = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Object object2 = new File(dir, "feature.dat");
            object2 = new FileInputStream((File)object2);
            int n2 = 8192;
            BufferedInputStream featureBin = object2 instanceof BufferedInputStream ? (BufferedInputStream)object2 : new BufferedInputStream((InputStream)object2, n2);
            Object object3 = new File(dir, "label.txt");
            object3 = new FileInputStream((File)object3);
            int n3 = 8192;
            BufferedInputStream labelText = object3 instanceof BufferedInputStream ? (BufferedInputStream)object3 : new BufferedInputStream((InputStream)object3, n3);
            return this.load(parameterBin, featureBin, labelText);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final NERPerceptron load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, @NotNull InputStream labelText) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
            Intrinsics.checkParameterIsNotNull((Object)featureBin, (String)"featureBin");
            Intrinsics.checkParameterIsNotNull((Object)labelText, (String)"labelText");
            PerceptronModel model = PerceptronModel.Companion.load(parameterBin, featureBin, true);
            Closeable closeable = labelText;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                InputStream inputStream = it;
                Charset charset = Charsets.UTF_8;
                Closeable closeable2 = inputStream;
                closeable2 = new InputStreamReader((InputStream)closeable2, charset);
                int n = 8192;
                list = TextStreamsKt.readLines((Reader)(closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            List labelList = list;
            return new NERPerceptron(model, labelList);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

