/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.perceptron.solution.ner;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.segment.WordAndNature;
import com.mayabot.nlp.segment.common.PkuWord;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015J,\u0010\u0016\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/mayabot/nlp/perceptron/solution/ner/NERPerceptronFeature;", "", "()V", "B", "", "E", "addFeature", "", "features", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "vector", "Lcom/mayabot/nlp/hppc/IntArrayList;", "stringBuilder", "Lcom/mayabot/nlp/common/FastStringBuilder;", "extractFeature", "sentence", "", "Lcom/mayabot/nlp/segment/common/PkuWord;", "position", "", "callBack", "Ljava/util/function/Consumer;", "extractFeatureVector", "Lcom/mayabot/nlp/segment/WordAndNature;", "buffer", "mynlp-segment"})
public final class NERPerceptronFeature {
    private static final String B = "_B_";
    private static final String E = "_E_";
    public static final NERPerceptronFeature INSTANCE;

    @NotNull
    public final IntArrayList extractFeatureVector(@NotNull List<? extends WordAndNature> sentence, int position, @NotNull FeatureSet features, @NotNull FastStringBuilder buffer) {
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull((Object)features, (String)"features");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        buffer.clear();
        int size = sentence.size();
        String pre3Word = B;
        String pre2Word = B;
        String pre2Pos = B;
        if (position >= 2) {
            WordAndNature x = sentence.get(position - 2);
            String string = x.getWord();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"x.word");
            pre2Word = string;
            String string2 = x.getNatureName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"x.natureName");
            pre2Pos = string2;
            if (position > 2) {
                String string3 = sentence.get(position - 3).getWord();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sentence[position - 3].word");
                pre3Word = string3;
            }
        }
        String preWord = B;
        String prePos = B;
        if (position >= 1) {
            WordAndNature x = sentence.get(position - 1);
            String string = x.getWord();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"x.word");
            preWord = string;
            String string4 = x.getNatureName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"x.natureName");
            prePos = string4;
        }
        WordAndNature cur = sentence.get(position);
        String curWord = cur.getWord();
        String curPos = cur.getNatureName();
        String nextWord = E;
        String nextPos = E;
        if (position <= size - 2) {
            WordAndNature x = sentence.get(position + 1);
            String string = x.getWord();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"x.word");
            nextWord = string;
            String string5 = x.getNatureName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"x.natureName");
            nextPos = string5;
        }
        String next2Word = E;
        String next2Pos = E;
        if (position <= size - 3) {
            WordAndNature x = sentence.get(position + 2);
            String string = x.getWord();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"x.word");
            next2Word = string;
            String string6 = x.getNatureName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"x.natureName");
            next2Pos = string6;
        }
        IntArrayList vector = new IntArrayList(15);
        buffer.append(pre2Word);
        buffer.append('1');
        this.addFeature(features, vector, buffer);
        buffer.append(preWord);
        buffer.append('2');
        this.addFeature(features, vector, buffer);
        buffer.append(curWord);
        buffer.append('3');
        this.addFeature(features, vector, buffer);
        buffer.append(nextWord);
        buffer.append('4');
        this.addFeature(features, vector, buffer);
        buffer.append(next2Word);
        buffer.append('5');
        this.addFeature(features, vector, buffer);
        buffer.append(pre2Pos);
        buffer.append('A');
        this.addFeature(features, vector, buffer);
        buffer.append(prePos);
        buffer.append('B');
        this.addFeature(features, vector, buffer);
        buffer.append(curPos);
        buffer.append('C');
        this.addFeature(features, vector, buffer);
        buffer.append(nextPos);
        buffer.append('D');
        this.addFeature(features, vector, buffer);
        buffer.append(next2Pos);
        buffer.append('E');
        this.addFeature(features, vector, buffer);
        buffer.append(pre2Pos);
        buffer.append(prePos);
        buffer.append('F');
        this.addFeature(features, vector, buffer);
        buffer.append(prePos);
        buffer.append(curPos);
        buffer.append('G');
        this.addFeature(features, vector, buffer);
        buffer.append(curPos);
        buffer.append(nextPos);
        buffer.append('H');
        this.addFeature(features, vector, buffer);
        buffer.append(nextPos);
        buffer.append(next2Pos);
        buffer.append('I');
        this.addFeature(features, vector, buffer);
        buffer.append(pre3Word);
        buffer.append('J');
        this.addFeature(features, vector, buffer);
        vector.add(0);
        return vector;
    }

    public final void extractFeature(@NotNull List<PkuWord> sentence, int position, @NotNull Consumer<String> callBack) {
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull(callBack, (String)"callBack");
        int size = sentence.size();
        String pre2Word = B;
        String pre3Word = B;
        String pre2Pos = B;
        if (position >= 2) {
            PkuWord x = sentence.get(position - 2);
            pre2Word = x.getWord();
            pre2Pos = x.getPos();
            if (position > 2) {
                pre3Word = sentence.get(position - 3).getWord();
            }
        }
        String preWord = B;
        String prePos = B;
        if (position >= 1) {
            PkuWord x = sentence.get(position - 1);
            preWord = x.getWord();
            prePos = x.getPos();
        }
        PkuWord cur = sentence.get(position);
        String curWord = cur.getWord();
        String curPos = cur.getPos();
        String nextWord = E;
        String nextPos = E;
        if (position <= size - 2) {
            PkuWord x = sentence.get(position + 1);
            nextWord = x.getWord();
            nextPos = x.getPos();
        }
        String next2Word = E;
        String next2Pos = E;
        if (position <= size - 3) {
            PkuWord x = sentence.get(position + 2);
            next2Word = x.getWord();
            next2Pos = x.getPos();
        }
        callBack.accept(pre2Word + '1');
        callBack.accept(preWord + '2');
        callBack.accept(curWord + '3');
        callBack.accept(nextWord + '4');
        callBack.accept(next2Word + '5');
        callBack.accept(pre2Pos + 'A');
        callBack.accept(prePos + 'B');
        callBack.accept(curPos + 'C');
        callBack.accept(nextPos + 'D');
        callBack.accept(next2Pos + 'E');
        callBack.accept(pre2Pos + prePos + 'F');
        callBack.accept(prePos + curPos + 'G');
        callBack.accept(curPos + nextPos + 'H');
        callBack.accept(nextPos + next2Pos + 'I');
        callBack.accept(pre3Word + 'J');
    }

    private final void addFeature(FeatureSet features, IntArrayList vector, FastStringBuilder stringBuilder) {
        int id = features.featureId(stringBuilder);
        stringBuilder.clear();
        if (id >= 0) {
            vector.add(id);
        }
    }

    private NERPerceptronFeature() {
    }

    static {
        NERPerceptronFeature nERPerceptronFeature;
        INSTANCE = nERPerceptronFeature = new NERPerceptronFeature();
    }
}

