/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.perceptron.solution.ner;

import com.mayabot.nlp.perceptron.DATFeatureSetBuilder;
import com.mayabot.nlp.perceptron.EvaluateRunner;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronTrainer;
import com.mayabot.nlp.perceptron.TrainSample;
import com.mayabot.nlp.perceptron.solution.ner.NEREvaluateUtils;
import com.mayabot.nlp.perceptron.solution.ner.NERPerceptron;
import com.mayabot.nlp.perceptron.solution.ner.NERPerceptronFeature;
import com.mayabot.nlp.perceptron.solution.ner.NERPerceptronTrainer;
import com.mayabot.nlp.perceptron.solution.ner.NerSamples;
import com.mayabot.nlp.segment.common.PerceptronUtilsKt;
import com.mayabot.nlp.segment.common.PkuWord;
import com.mayabot.nlp.utils.CharNormUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR&\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/mayabot/nlp/perceptron/solution/ner/NERPerceptronTrainer;", "", "()V", "targetPos", "", "", "(Ljava/util/Set;)V", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "getFeatureSet", "()Lcom/mayabot/nlp/perceptron/FeatureSet;", "setFeatureSet", "(Lcom/mayabot/nlp/perceptron/FeatureSet;)V", "labelMap", "", "", "getLabelMap", "()Ljava/util/Map;", "setLabelMap", "(Ljava/util/Map;)V", "getTargetPos", "()Ljava/util/Set;", "prepareFeatureSet", "", "corposFiles", "", "Ljava/io/File;", "labelCount", "train", "Lcom/mayabot/nlp/perceptron/solution/ner/NERPerceptron;", "trainFiles", "evaluate", "maxIter", "threadNumber", "mynlp-segment"})
public final class NERPerceptronTrainer {
    @NotNull
    public FeatureSet featureSet;
    @NotNull
    private Map<String, Integer> labelMap;
    @NotNull
    private final Set<String> targetPos;

    @NotNull
    public final FeatureSet getFeatureSet() {
        FeatureSet featureSet = this.featureSet;
        if (featureSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureSet");
        }
        return featureSet;
    }

    public final void setFeatureSet(@NotNull FeatureSet featureSet) {
        Intrinsics.checkParameterIsNotNull((Object)featureSet, (String)"<set-?>");
        this.featureSet = featureSet;
    }

    @NotNull
    public final Map<String, Integer> getLabelMap() {
        return this.labelMap;
    }

    public final void setLabelMap(@NotNull Map<String, Integer> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.labelMap = map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NERPerceptron train(@NotNull File trainFiles, @NotNull File evaluate2, int maxIter, int threadNumber) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)trainFiles, (String)"trainFiles");
        Intrinsics.checkParameterIsNotNull((Object)evaluate2, (String)"evaluate");
        ArrayList labelList = new ArrayList(CollectionsKt.sorted((Iterable)this.labelMap.keySet()));
        List allFiles2 = trainFiles.isFile() ? CollectionsKt.listOf((Object)trainFiles) : SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)trainFiles)), (Function1)train.allFiles.1.INSTANCE));
        this.prepareFeatureSet(allFiles2, labelList.size());
        StringBuilder stringBuilder = new StringBuilder().append("Feature Set Size ");
        FeatureSet featureSet = this.featureSet;
        if (featureSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureSet");
        }
        String string = stringBuilder.append(featureSet.size()).toString();
        System.out.println((Object)string);
        FeatureSet featureSet2 = this.featureSet;
        if (featureSet2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureSet");
        }
        ArrayList<TrainSample> sampleList = new NerSamples(this.targetPos, this.labelMap, featureSet2).prepareSample(allFiles2);
        Object $receiver$iv = PerceptronUtilsKt.allFiles(evaluate2);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = FilesKt.readLines$default((File)it, null, (int)1, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List evaluateList = (List)destination$iv$iv;
        $receiver$iv = "Start Train ... ";
        System.out.println($receiver$iv);
        FeatureSet featureSet3 = this.featureSet;
        if (featureSet3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureSet");
        }
        PerceptronTrainer trainer2 = new PerceptronTrainer(featureSet3, this.labelMap.size(), (List<TrainSample>)sampleList, new EvaluateRunner(this, labelList, evaluateList){
            final /* synthetic */ NERPerceptronTrainer this$0;
            final /* synthetic */ ArrayList $labelList;
            final /* synthetic */ List $evaluateList;

            public final void run(int $noName_0, Perceptron model) {
                Perceptron perceptron = model;
                Intrinsics.checkExpressionValueIsNotNull((Object)perceptron, (String)"model");
                NERPerceptron ner = new NERPerceptron(perceptron, this.$labelList);
                NEREvaluateUtils.INSTANCE.evaluateNER(ner, this.$evaluateList, this.this$0.getTargetPos());
            }
            {
                this.this$0 = nERPerceptronTrainer;
                this.$labelList = arrayList;
                this.$evaluateList = list;
            }
        }, maxIter, false);
        Perceptron model = trainer2.train(threadNumber);
        NERPerceptron ner = new NERPerceptron(model, labelList);
        NEREvaluateUtils.INSTANCE.evaluateNER(ner, evaluateList, this.targetPos);
        return ner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void prepareFeatureSet(List<? extends File> corposFiles, int labelCount) {
        void $receiver$iv;
        String string = "\u5f00\u59cb\u6784\u5efaNER FeatureSet";
        System.out.println((Object)string);
        long t1 = System.currentTimeMillis();
        DATFeatureSetBuilder builder = new DATFeatureSetBuilder(labelCount);
        Consumer fit2 = new Consumer<String>(builder){
            final /* synthetic */ DATFeatureSetBuilder $builder;

            public final void accept(@NotNull String f) {
                Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
                this.$builder.put(f);
            }
            {
                this.$builder = dATFeatureSetBuilder;
            }
        };
        Object object = corposFiles;
        for (Object element$iv : $receiver$iv) {
            Object object2;
            File file = (File)element$iv;
            boolean bl = false;
            String string2 = file.getAbsolutePath();
            System.out.println((Object)string2);
            File $receiver$iv2 = file;
            Charset charset$iv = Charsets.UTF_8;
            Object object3 = $receiver$iv2;
            int n = 8192;
            Object object4 = object2 = object3;
            object4 = new FileInputStream((File)object4);
            object2 = new InputStreamReader((InputStream)object4, charset$iv);
            object3 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)object3;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl2 = false;
                Sequence $receiver$iv3 = lines;
                for (Object element$iv2 : $receiver$iv3) {
                    String line = (String)element$iv2;
                    boolean bl3 = false;
                    List<PkuWord> flatWords = PerceptronUtilsKt.parseToFlatWords(line);
                    Iterable $receiver$iv222 = flatWords;
                    for (Object element$iv3 : $receiver$iv222) {
                        PkuWord w = (PkuWord)element$iv3;
                        boolean bl4 = false;
                        String string3 = CharNormUtils.convert(w.getWord());
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"CharNormUtils.convert(w.word)");
                        w.setWord(string3);
                    }
                    int $receiver$iv222 = 0;
                    int n2 = flatWords.size();
                    while ($receiver$iv222 < n2) {
                        void i;
                        NERPerceptronFeature.INSTANCE.extractFeature(flatWords, (int)i, fit2);
                        ++i;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
            }
        }
        object = "Start build featureSet ...";
        System.out.println(object);
        this.featureSet = builder.build();
        object = "FeatureSet \u6784\u5efa\u5b8c\u6210,\u7528\u65f6" + (System.currentTimeMillis() - t1) + "ms";
        System.out.println(object);
    }

    @NotNull
    public final Set<String> getTargetPos() {
        return this.targetPos;
    }

    /*
     * WARNING - void declaration
     */
    public NERPerceptronTrainer(@NotNull Set<String> targetPos) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(targetPos, (String)"targetPos");
        this.targetPos = targetPos;
        TreeSet<String> set = new TreeSet<String>();
        set.add("O");
        set.add("S");
        Iterable iterable = this.targetPos;
        TreeSet<String> treeSet = set;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])new String[]{"B-" + it, "M-" + it, "E-" + it});
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        treeSet.addAll(list);
        this.labelMap = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)CollectionsKt.toList((Iterable)set), (Iterable)((Iterable)RangesKt.until((int)0, (int)set.size()))));
    }

    public NERPerceptronTrainer() {
        this(SetsKt.setOf((Object[])new String[]{"ns", "nt"}));
    }
}

