/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.pinyin;

import com.mayabot.nlp.collection.ahocorasick.AhoCoraickDoubleArrayTrieBuilder;
import com.mayabot.nlp.collection.ahocorasick.AhoCorasickDoubleArrayTrie;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.pinyin.CustomPinyin;
import com.mayabot.nlp.pinyin.PinyinResult;
import com.mayabot.nlp.pinyin.model.Pinyin;
import com.mayabot.t.google.common.primitives.Ints;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public abstract class BasePinyinDictionary {
    InternalLogger logger = InternalLoggerFactory.getInstance(BasePinyinDictionary.class);
    private AhoCorasickDoubleArrayTrie<Pinyin[]> trie = null;
    private CustomPinyin customPinyin = new CustomPinyin();
    private TreeMap<String, Pinyin[]> system;
    static Pinyin[] pinyinByOrdinal = new Pinyin[Pinyin.values().length + 1];

    public void rebuild() {
        long t1 = System.currentTimeMillis();
        if (this.system == null) {
            this.system = this.load();
        }
        TreeMap<Object, Object> map = new TreeMap();
        if (this.customPinyin != null && !this.customPinyin.getMap().isEmpty()) {
            map.putAll(this.system);
            TreeMap<Object, Object> map2 = map;
            this.customPinyin.getMap().forEach((key, value) -> map2.put(key, this.parse((String)value)));
        } else {
            map = this.system;
        }
        AhoCoraickDoubleArrayTrieBuilder<Object> builder = new AhoCoraickDoubleArrayTrieBuilder<Object>();
        this.trie = builder.build(map);
        long t2 = System.currentTimeMillis();
        this.logger.info("Pinyin Dictionary rebuild use time {} ms", (Object)(t2 - t1));
    }

    abstract TreeMap<String, Pinyin[]> load();

    public PinyinResult text2Pinyin(String text) {
        return new PinyinResult(this.segLongest(text.toCharArray()), text);
    }

    protected List<Pinyin> segLongest(char[] charArray) {
        Pinyin[][] wordNet = new Pinyin[charArray.length][];
        this.trie.parseText(charArray, (begin, end, value) -> {
            int length = end - begin;
            if (wordNet[begin] == null || length > wordNet[begin].length) {
                Pinyin[] pinyinArray;
                if (length == 1) {
                    Pinyin[] pinyinArray2 = new Pinyin[1];
                    pinyinArray = pinyinArray2;
                    pinyinArray2[0] = value[0];
                } else {
                    pinyinArray = value;
                }
                wordNet[begin] = pinyinArray;
            }
        });
        ArrayList<Pinyin> pinyinList = new ArrayList<Pinyin>(charArray.length);
        int offset = 0;
        while (offset < wordNet.length) {
            if (wordNet[offset] == null) {
                pinyinList.add(Pinyin.none5);
                ++offset;
                continue;
            }
            Collections.addAll(pinyinList, wordNet[offset]);
            offset += wordNet[offset].length;
        }
        return pinyinList;
    }

    public static Pinyin[] read(DataInput in) {
        try {
            String line = in.readUTF();
            String[] split = line.split(",");
            Pinyin[] pinyins = new Pinyin[split.length];
            for (int i = 0; i < split.length; ++i) {
                Pinyin pinyin;
                Integer xx = Ints.tryParse(split[i]);
                pinyins[i] = pinyin = pinyinByOrdinal[xx];
            }
            return pinyins;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Pinyin[] parse(String text) {
        String[] values = text.split(",");
        Pinyin[] pinyins = new Pinyin[values.length];
        boolean error = false;
        for (int i = 0; i < values.length; ++i) {
            try {
                Pinyin pinyin;
                pinyins[i] = pinyin = Pinyin.valueOf(values[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("\u8bfb\u53d6\u62fc\u97f3\u8bcd\u5178\uff0c\u89e3\u6790" + text + "\u9519\u8bef");
                error = true;
            }
        }
        if (!error) {
            return pinyins;
        }
        return null;
    }

    public CustomPinyin getCustomPinyin() {
        return this.customPinyin;
    }

    static {
        Pinyin[] values = Pinyin.values();
        for (int i = values.length - 1; i >= 0; --i) {
            BasePinyinDictionary.pinyinByOrdinal[values[i].ordinal()] = values[i];
        }
    }
}

