/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.pinyin;

import com.mayabot.nlp.pinyin.model.Pinyin;
import com.mayabot.nlp.utils.Characters;
import com.mayabot.t.google.common.base.Joiner;
import com.mayabot.t.google.common.collect.ImmutableMap;
import com.mayabot.t.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PinyinResult {
    private List<Pinyin> pinyinList;
    private String text;
    private boolean skipNull = false;
    private boolean ignorePunctuation = true;
    private boolean fuzzy;
    private static Pattern pattern = Pattern.compile("(^zh|^ch|^sh|iang$|ang$|ing$|eng$|uang$)");
    private static ImmutableMap<String, String> fuzzyMap = ImmutableMap.builder().put("zh", "z").put("ch", "c").put("sh", "s").put("eng", "en").put("ang", "an").put("ing", "in").put("iang", "ian").put("uang", "uan").build();

    PinyinResult(List<Pinyin> pinyinList, String text) {
        this.pinyinList = pinyinList;
        this.text = text;
    }

    public PinyinResult fuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
        return this;
    }

    public PinyinResult skipNull(boolean skipNull) {
        this.skipNull = skipNull;
        return this;
    }

    public PinyinResult ignorePunctuation(boolean ignore) {
        this.ignorePunctuation = this.ignorePunctuation;
        return this;
    }

    public String asString() {
        return this.asString(" ");
    }

    public static void main(String[] args) {
    }

    public List<String> asList() {
        ArrayList<String> list = Lists.newArrayListWithCapacity(this.pinyinList.size());
        int i = 0;
        for (Pinyin pinyin : this.pinyinList) {
            if (pinyin == Pinyin.none5 && !this.skipNull) {
                char x = this.text.charAt(i);
                if (!this.ignorePunctuation || !Characters.isPunctuation(x)) {
                    list.add(this.text.charAt(i) + "");
                }
            } else {
                String withoutTone = pinyin.getPinyinWithoutTone();
                if (this.fuzzy) {
                    Matcher matcher = pattern.matcher(withoutTone);
                    StringBuffer sb = new StringBuffer();
                    if (matcher.find()) {
                        String part = matcher.group();
                        matcher.appendReplacement(sb, fuzzyMap.get(part));
                    }
                    matcher.appendTail(sb);
                    list.add(sb.toString());
                } else {
                    list.add(withoutTone);
                }
            }
            ++i;
        }
        return list;
    }

    public List<Character> asHeadList() {
        ArrayList<Character> list = Lists.newArrayListWithCapacity(this.pinyinList.size());
        int i = 0;
        for (Pinyin pinyin : this.pinyinList) {
            if (pinyin == Pinyin.none5 && !this.skipNull) {
                char x = this.text.charAt(i);
                if (!this.ignorePunctuation || !Characters.isPunctuation(x)) {
                    list.add(Character.valueOf(this.text.charAt(i)));
                }
            } else {
                list.add(Character.valueOf(pinyin.getFirstChar()));
            }
            ++i;
        }
        return list;
    }

    public String asString(String splitter) {
        return Joiner.on(splitter).join(this.asList());
    }

    public String asHeadString(String splitter) {
        return Joiner.on(splitter).join(this.asHeadList());
    }

    public String asHeadString() {
        return Joiner.on(" ").join(this.asHeadList());
    }

    public String toString() {
        return this.asString();
    }
}

