/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.resources;

import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.nlp.resources.NlpResourceFactory;
import com.mayabot.t.google.common.io.ByteSource;
import com.mayabot.t.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class FileNlpResourceFactory
implements NlpResourceFactory {
    private File baseDir;

    public FileNlpResourceFactory(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public NlpResource load(String resourceName, Charset charset) {
        if (!this.baseDir.exists() || this.baseDir.isFile()) {
            return null;
        }
        File file = new File(this.baseDir, resourceName.replace('/', File.separatorChar));
        if (file.exists() && file.canRead()) {
            return new FileMynlpResource(file, charset);
        }
        return null;
    }

    public static class FileMynlpResource
    implements NlpResource {
        private final File file;
        private Charset charset;

        public FileMynlpResource(File file, Charset charset) {
            this.file = file;
            this.charset = charset;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            ByteSource byteSource = Files.asByteSource(this.file);
            return byteSource.openBufferedStream();
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }
    }
}

