/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.resources;

import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.nlp.resources.NlpResourceFactory;
import com.mayabot.t.google.common.base.Preconditions;
import com.mayabot.t.google.common.base.Strings;
import com.mayabot.t.google.common.collect.Lists;
import com.mayabot.t.google.common.collect.Maps;
import com.mayabot.t.google.common.collect.Ordering;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarNlpResourceFactory
implements NlpResourceFactory {
    InternalLogger logger = InternalLoggerFactory.getInstance(JarNlpResourceFactory.class);
    private File baseDir;

    public JarNlpResourceFactory(File baseDir) {
        this.baseDir = baseDir;
    }

    private Map<String, File> doIndex() {
        HashMap<String, File> index = Maps.newHashMap();
        List<File> jarFiles = Ordering.from(Comparator.comparing(file -> {
            String text = file.getName();
            Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.jar$");
            StringBuffer sb = new StringBuffer();
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                String v1 = Strings.padStart(matcher.group(1), 3, '0');
                String v2 = Strings.padStart(matcher.group(2), 3, '0');
                String v3 = Strings.padStart(matcher.group(3), 3, '0');
                matcher.appendReplacement(sb, v1 + "." + v2 + "." + v3 + ".jar");
            }
            matcher.appendTail(sb);
            return sb.toString();
        }, String.CASE_INSENSITIVE_ORDER)).sortedCopy(Lists.newArrayList(this.baseDir.listFiles(file -> file.isFile() && file.getName().endsWith(".jar"))));
        try {
            for (File jar : jarFiles) {
                ZipFile f = new ZipFile(jar);
                Throwable throwable = null;
                try {
                    Enumeration<? extends ZipEntry> entries = f.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                        if (zipEntry.isDirectory()) continue;
                        String name = zipEntry.getName();
                        index.put(name, jar);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (f == null) continue;
                    if (throwable != null) {
                        try {
                            f.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    f.close();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("", e);
            e.printStackTrace();
        }
        long t2 = System.currentTimeMillis();
        return index;
    }

    @Override
    public NlpResource load(String resourceName, Charset charset) {
        Map<String, File> index = this.doIndex();
        if (!this.baseDir.exists() || this.baseDir.isFile()) {
            return null;
        }
        File jar = index.get(resourceName);
        if (jar == null) {
            return null;
        }
        try {
            ZipFile zipFile = new ZipFile(jar);
            ZipEntry entry = zipFile.getEntry(resourceName);
            if (entry == null) {
                return null;
            }
            zipFile.close();
            return new ZipedMynlpResource(jar, charset, resourceName);
        }
        catch (IOException e) {
            this.logger.error("load resource " + resourceName, e);
            return null;
        }
    }

    private long copy(InputStream from, byte[] to) throws IOException {
        int r;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        byte[] buf = new byte[8192];
        long total = 0L;
        int last = 0;
        while ((r = from.read(buf)) != -1) {
            for (int i = 0; i < r; ++i) {
                to[last++] = buf[i];
            }
            total += (long)r;
        }
        return total;
    }

    public static class ZipedMynlpResource
    implements NlpResource {
        private final String resourceName;
        private final File file;
        private Charset charset;

        public ZipedMynlpResource(File file, Charset charset, String resourceName) {
            this.file = file;
            this.charset = charset;
            this.resourceName = resourceName;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String hash() {
            try (ZipFile zipFile = new ZipFile(this.file);){
                ZipEntry entry = zipFile.getEntry(this.resourceName);
                String string = entry.getCrc() + "";
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "-1";
            }
        }

        @Override
        public InputStream openInputStream() throws IOException {
            final ZipFile zipFile = new ZipFile(this.file);
            ZipEntry entry = zipFile.getEntry(this.resourceName);
            return new BufferedInputStream(zipFile.getInputStream(entry), 16384){

                @Override
                public void close() throws IOException {
                    super.close();
                    zipFile.close();
                }
            };
        }

        public String toString() {
            return this.file + "@" + this.resourceName;
        }
    }
}

