/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.resources;

import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.t.google.common.io.FileWriteMode;
import com.mayabot.t.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class NlpResouceExternalizable
implements Externalizable {
    public abstract String sourceVersion(MynlpEnv var1);

    public abstract void loadFromSource(MynlpEnv var1) throws Exception;

    public void restore(MynlpEnv mynlp) throws Exception {
        InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
        boolean success = false;
        String sourceName = this.getClass().getSimpleName();
        File cache = new File(new File(mynlp.getCacheDir(), sourceName), this.sourceVersion(mynlp) + ".dat");
        Files.createParentDirs(cache);
        boolean loadFromBin = false;
        if (cache != null && cache.exists() && cache.canRead()) {
            try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(cache), 65536));){
                long t1 = System.currentTimeMillis();
                this.readExternal(in);
                long t2 = System.currentTimeMillis();
                success = true;
                loadFromBin = true;
                logger.info(cache.getName() + " restore from cache file success, use time " + (t2 - t1) + " ms");
            }
            catch (Exception e) {
                logger.warn("restore from cache " + cache.getAbsolutePath(), e);
            }
        }
        if (!success) {
            long t1 = System.currentTimeMillis();
            this.loadFromSource(mynlp);
            long t2 = System.currentTimeMillis();
            logger.info("restore from data source, use time " + (t2 - t1) + " ms");
            if (!loadFromBin && cache != null) {
                long t3 = System.currentTimeMillis();
                try (ObjectOutputStream outputStream = new ObjectOutputStream(new BufferedOutputStream(Files.asByteSink(cache, new FileWriteMode[0]).openStream(), 65536));){
                    this.writeExternal(outputStream);
                    outputStream.flush();
                }
                long t4 = System.currentTimeMillis();
                logger.info("save cache file success, use time " + (t4 - t3) + " ms");
            }
        }
    }
}

