/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment;

import java.util.HashMap;
import java.util.Map;

public enum Nature {
    a,
    Ag,
    ad,
    an,
    b,
    Bg,
    c,
    d,
    Dg,
    e,
    f,
    h,
    i,
    j,
    k,
    l,
    m,
    Mg,
    n,
    nr,
    ns,
    nt,
    nx,
    nz,
    Ng,
    o,
    p,
    q,
    r,
    Rg,
    s,
    t,
    Tg,
    u,
    v,
    vd,
    vn,
    Vg,
    w,
    y,
    Yg,
    z,
    xx,
    mq,
    x,
    begin,
    end,
    newWord;

    static Map<String, Nature> map;

    public boolean isN() {
        return (this.name().charAt(0) == 'n' || this == Ng) && this != nx;
    }

    public static Nature parse(String pos) {
        if (pos == null || pos.isEmpty()) {
            return x;
        }
        Nature n = map.get(pos);
        if (n != null) {
            return n;
        }
        switch (pos.charAt(0)) {
            case 'n': {
                return Nature.n;
            }
            case 'a': {
                return a;
            }
            case 'v': {
                return v;
            }
            case 'd': {
                return d;
            }
        }
        return x;
    }

    static {
        map = new HashMap<String, Nature>(Nature.values().length * 5);
        for (Nature n : Nature.values()) {
            map.put(n.name(), n);
        }
    }
}

