/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment;

import com.mayabot.nlp.segment.CharNormalize;
import com.mayabot.nlp.segment.MynlpTokenizer;
import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.PipelineTokenizerBuilder;
import com.mayabot.nlp.segment.WordSplitAlgorithm;
import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.WordTermCollector;
import com.mayabot.nlp.segment.WordpathProcessor;
import com.mayabot.nlp.segment.wordnet.BestPathAlgorithm;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import com.mayabot.nlp.segment.wordnet.Wordpath;
import com.mayabot.nlp.utils.Characters;
import com.mayabot.nlp.utils.StringUtils;
import com.mayabot.t.google.common.base.Joiner;
import com.mayabot.t.google.common.base.Preconditions;
import com.mayabot.t.google.common.collect.ImmutableList;
import com.mayabot.t.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class PipelineTokenizer
implements MynlpTokenizer {
    private BestPathAlgorithm bestPathAlgorithm;
    private WordTermCollector collector;
    private CharNormalize[] charNormalizes;
    private WordSplitAlgorithm[] initer;
    private WordpathProcessor[] pipeline;

    public static PipelineTokenizerBuilder builder() {
        return new PipelineTokenizerBuilder();
    }

    PipelineTokenizer(List<WordSplitAlgorithm> initer, WordpathProcessor[] pipeline, BestPathAlgorithm bestPathAlgorithm, WordTermCollector termCollector, List<CharNormalize> charNormalizes) {
        this.initer = initer.toArray(new WordSplitAlgorithm[0]);
        this.pipeline = pipeline;
        this.bestPathAlgorithm = bestPathAlgorithm;
        this.collector = termCollector;
        this.charNormalizes = charNormalizes.toArray(new CharNormalize[0]);
        Preconditions.checkNotNull(bestPathAlgorithm);
        Preconditions.checkNotNull(this.initer);
        Preconditions.checkNotNull(pipeline);
    }

    @Override
    public void token(char[] text, Consumer<WordTerm> consumer) {
        if (this.charNormalizes != null) {
            for (CharNormalize normalize : this.charNormalizes) {
                normalize.normal(text);
            }
        }
        if (text.length == 0) {
            return;
        }
        if (text.length == 1 && StringUtils.isWhiteSpace(text[0])) {
            WordTerm wordTerm;
            if (StringUtils.isWhiteSpace(text[0]) || Characters.isPunctuation(text[0])) {
                wordTerm = new WordTerm(new String(text), Nature.w);
                consumer.accept(wordTerm);
            } else {
                wordTerm = new WordTerm(new String(text), Nature.x);
                consumer.accept(wordTerm);
            }
            return;
        }
        Wordnet wordnet = new Wordnet(text);
        for (WordSplitAlgorithm initializer : this.initer) {
            initializer.fill(wordnet);
        }
        wordnet.fillNill();
        Wordpath wordPath = this.bestPathAlgorithm.select(wordnet);
        for (WordpathProcessor processor : this.pipeline) {
            if (!processor.isEnabled()) continue;
            wordPath = processor.process(wordPath);
        }
        this.collector.collect(wordnet, wordPath, consumer);
    }

    public List<WordpathProcessor> getPipeline() {
        return ImmutableList.copyOf(this.pipeline);
    }

    public WordTermCollector getCollector() {
        return this.collector;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PipelineTokenizer\n\n");
        sb.append("BestPathAlgorithm = " + this.bestPathAlgorithm.getClass().getSimpleName()).append("\n");
        sb.append("CharNormalize = " + Joiner.on(",").join(Lists.newArrayList(this.charNormalizes).stream().map(it -> it.getClass().getSimpleName()).collect(Collectors.toList()))).append("\n");
        sb.append("WordTermCollector = " + this.collector.getClass().getSimpleName() + "\n");
        sb.append("WordSplitAlgorithm = " + Joiner.on(",").join(Lists.newArrayList(this.initer).stream().map(it -> it.getClass().getSimpleName()).collect(Collectors.toList()))).append("\n");
        sb.append("WordpathProcessor = \n");
        for (WordpathProcessor processor : this.pipeline) {
            sb.append("\t" + processor.getClass().getSimpleName()).append("\n");
        }
        return sb.toString();
    }
}

