/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment;

import com.mayabot.nlp.Mynlp;
import com.mayabot.nlp.Mynlps;
import com.mayabot.nlp.segment.CharNormalize;
import com.mayabot.nlp.segment.MynlpTokenizer;
import com.mayabot.nlp.segment.MynlpTokenizerBuilder;
import com.mayabot.nlp.segment.PipelineTokenizer;
import com.mayabot.nlp.segment.SegmentComponent;
import com.mayabot.nlp.segment.WordSplitAlgorithm;
import com.mayabot.nlp.segment.WordTermCollector;
import com.mayabot.nlp.segment.WordpathProcessor;
import com.mayabot.nlp.segment.common.DefaultCharNormalize;
import com.mayabot.nlp.segment.plugins.collector.SentenceCollector;
import com.mayabot.nlp.segment.plugins.collector.SentenceIndexWordCollector;
import com.mayabot.nlp.segment.wordnet.BestPathAlgorithm;
import com.mayabot.t.google.common.base.Preconditions;
import com.mayabot.t.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

public class PipelineTokenizerBuilder
implements MynlpTokenizerBuilder {
    private final Mynlp mynlp;
    private BestPathAlgorithm bestPathAlgorithm;
    private List<CharNormalize> charNormalizes = Lists.newArrayList(DefaultCharNormalize.instace);
    private LinkedList<WordSplitAlgorithm> wordSplitAlgorithm = Lists.newLinkedList();
    private LinkedList<WordpathProcessor> pipeLine = Lists.newLinkedList();
    private List<ConsumerPair> configListener = Lists.newArrayList();
    private WordTermCollector termCollector;
    private boolean enableIndexModel = false;

    public PipelineTokenizerBuilder() {
        this.mynlp = Mynlps.get();
    }

    protected void setUp() {
    }

    @Override
    public MynlpTokenizer build() {
        this.setUp();
        Preconditions.checkNotNull(this.bestPathAlgorithm);
        Preconditions.checkState(!this.wordSplitAlgorithm.isEmpty());
        if (this.termCollector == null) {
            this.termCollector = this.enableIndexModel ? (WordTermCollector)this.mynlp.getInstance(SentenceIndexWordCollector.class) : (WordTermCollector)this.mynlp.getInstance(SentenceCollector.class);
        }
        this.callListener();
        Collections.sort(this.wordSplitAlgorithm);
        Collections.sort(this.pipeLine);
        return new PipelineTokenizer(Lists.newArrayList(this.wordSplitAlgorithm), this.pipeLine.toArray(new WordpathProcessor[0]), this.bestPathAlgorithm, this.termCollector, this.charNormalizes);
    }

    private void callListener() {
        this.configListener.forEach(pair -> {
            if (pair.clazz.equals(this.termCollector.getClass()) || pair.clazz.isAssignableFrom(this.termCollector.getClass())) {
                pair.consumer.accept(this.termCollector);
            }
        });
        this.configListener.forEach(pair -> this.wordSplitAlgorithm.forEach(wf -> {
            if (pair.clazz.equals(wf.getClass()) || pair.clazz.isAssignableFrom(wf.getClass())) {
                pair.consumer.accept(wf);
            }
        }));
        this.configListener.forEach(pair -> this.pipeLine.forEach(it -> {
            if (pair.clazz.equals(it.getClass()) || pair.clazz.isAssignableFrom(it.getClass())) {
                pair.consumer.accept(it);
            }
        }));
    }

    public <T> PipelineTokenizerBuilder config(Class<T> clazz, Consumer<T> listener) {
        this.configListener.add(new ConsumerPair(clazz, listener));
        return this;
    }

    public PipelineTokenizerBuilder disabledComponent(Class<? extends SegmentComponent> clazz) {
        this.config(clazz, x -> x.disable());
        return this;
    }

    public PipelineTokenizerBuilder enableComponent(Class<? extends SegmentComponent> clazz) {
        this.config(clazz, x -> x.enable());
        return this;
    }

    public PipelineTokenizerBuilder addCharNormalize(Class<? extends CharNormalize> charNormalizeClass) {
        this.charNormalizes.add(this.mynlp.getInstance(charNormalizeClass));
        return this;
    }

    public PipelineTokenizerBuilder addCharNormalize(CharNormalize charNormalize) {
        this.charNormalizes.add(charNormalize);
        return this;
    }

    public PipelineTokenizerBuilder removeCharNormalize(Class<? extends CharNormalize> clazz) {
        this.charNormalizes.removeIf(obj -> clazz.isAssignableFrom(obj.getClass()) || obj.getClass().equals(clazz));
        return this;
    }

    public PipelineTokenizerBuilder setBestPathAlgorithm(BestPathAlgorithm bestPathAlgorithm) {
        this.bestPathAlgorithm = bestPathAlgorithm;
        return this;
    }

    public PipelineTokenizerBuilder setBestPathComputer(Class<? extends BestPathAlgorithm> clazz) {
        this.bestPathAlgorithm = this.mynlp.getInstance(clazz);
        return this;
    }

    public PipelineTokenizerBuilder addProcessor(WordpathProcessor processor) {
        this.pipeLine.add(processor);
        Collections.sort(this.pipeLine);
        return this;
    }

    public PipelineTokenizerBuilder addProcessor(Class<? extends WordpathProcessor> clazz) {
        this.addProcessor(this.mynlp.getInstance(clazz));
        return this;
    }

    public PipelineTokenizerBuilder addWordSplitAlgorithm(WordSplitAlgorithm algorithm) {
        this.wordSplitAlgorithm.add(algorithm);
        Collections.sort(this.wordSplitAlgorithm);
        return this;
    }

    public PipelineTokenizerBuilder addWordSplitAlgorithm(Class<? extends WordSplitAlgorithm> algorithm) {
        this.addWordSplitAlgorithm(this.mynlp.getInstance(algorithm));
        return this;
    }

    public PipelineTokenizerBuilder setTermCollector(WordTermCollector termCollector) {
        this.termCollector = termCollector;
        return this;
    }

    public PipelineTokenizerBuilder setTermCollector(Class<? extends WordTermCollector> termCollectorClass) {
        this.termCollector = this.mynlp.getInstance(termCollectorClass);
        return this;
    }

    public WordTermCollector getTermCollector() {
        return this.termCollector;
    }

    public SentenceIndexWordCollector getIndexTermCollector() {
        return (SentenceIndexWordCollector)this.termCollector;
    }

    public boolean isEnableIndexModel() {
        return this.enableIndexModel;
    }

    public PipelineTokenizerBuilder setEnableIndexModel(boolean enableIndexModel) {
        this.enableIndexModel = enableIndexModel;
        return this;
    }

    private static class ConsumerPair {
        Class clazz;
        Consumer consumer;

        public ConsumerPair(Class clazz, Consumer consumer) {
            this.clazz = clazz;
            this.consumer = consumer;
        }
    }
}

