/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment;

import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.t.google.common.base.Joiner;
import com.mayabot.t.google.common.collect.ImmutableList;
import com.mayabot.t.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public final class Sentence {
    private List<WordTerm> words;

    public static final Sentence of(List<WordTerm> words) {
        return new Sentence(words);
    }

    public Sentence(List<WordTerm> words) {
        this.words = words;
    }

    public Sentence() {
        this.words = ImmutableList.of();
    }

    public String toWordString() {
        return Joiner.on(' ').join(this.asStringList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int size = this.words.size();
        int last = size - 1;
        for (int i = 0; i < size; ++i) {
            WordTerm term = this.words.get(i);
            if (term.hasSubword()) {
                sb.append("[");
                sb.append(new Sentence(term.getSubword()).toString());
                sb.append("]");
                if (term.getNature() != null) {
                    sb.append("/");
                    sb.append((Object)term.getNature());
                }
                sb.append(" ");
                continue;
            }
            sb.append(term.word);
            if (term.getNature() != null) {
                sb.append("/");
                sb.append((Object)term.getNature());
            }
            if (i >= last) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public List<String> asStringList() {
        ArrayList<String> list = Lists.newArrayListWithExpectedSize(this.words.size());
        for (WordTerm w : this.words) {
            list.add(w.word);
        }
        return list;
    }

    public String pkuFormat() {
        return this.toString();
    }

    public List<WordTerm> asWordList() {
        return this.words;
    }
}

