/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.analyzer;

import com.mayabot.nlp.Mynlps;
import com.mayabot.nlp.segment.MynlpTokenizer;
import com.mayabot.nlp.segment.analyzer.BaseMynlpAnalyzer;
import com.mayabot.nlp.segment.analyzer.PunctuationFilter;
import com.mayabot.nlp.segment.analyzer.StopWordDict;
import com.mayabot.nlp.segment.analyzer.StopwordFilter;
import com.mayabot.nlp.segment.analyzer.WordTermGenerator;
import java.util.HashSet;
import java.util.Set;

public class DefaultMynlpAnalyzer
extends BaseMynlpAnalyzer {
    private boolean filterPunctuaction = true;
    private boolean fillStopWord = false;
    Set<String> stopWords;

    public DefaultMynlpAnalyzer(MynlpTokenizer tokenizer, Set<String> stopWords) {
        super(tokenizer);
        this.setStopWords(stopWords);
    }

    public DefaultMynlpAnalyzer(MynlpTokenizer tokenizer) {
        this(tokenizer, null);
    }

    @Override
    protected WordTermGenerator warp(WordTermGenerator base) {
        if (this.filterPunctuaction) {
            base = new PunctuationFilter(base);
        }
        if (this.fillStopWord) {
            base = new StopwordFilter(base, this.stopWords);
        }
        return base;
    }

    public boolean isFilterPunctuaction() {
        return this.filterPunctuaction;
    }

    public DefaultMynlpAnalyzer setFilterPunctuaction(boolean filterPunctuaction) {
        this.filterPunctuaction = filterPunctuaction;
        return this;
    }

    public boolean isFillStopWord() {
        return this.fillStopWord;
    }

    public DefaultMynlpAnalyzer setFillStopWord(boolean fillStopWord) {
        this.fillStopWord = fillStopWord;
        return this;
    }

    public Set<String> getStopWords() {
        return this.stopWords;
    }

    public DefaultMynlpAnalyzer setStopWords(Set<String> stopWords) {
        this.stopWords = new HashSet<String>();
        Set<String> defaultSet = Mynlps.instanceOf(StopWordDict.class).getSet();
        if (stopWords == null) {
            this.stopWords.addAll(defaultSet);
        } else {
            this.stopWords.addAll(stopWords);
        }
        return this;
    }
}

