/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.analyzer;

import com.mayabot.nlp.common.FastCharReader;
import com.mayabot.nlp.common.ParagraphReader;
import com.mayabot.nlp.common.ParagraphReaderSmart;
import com.mayabot.nlp.common.ParagraphReaderString;
import com.mayabot.nlp.segment.MynlpTokenizer;
import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.analyzer.WordTermGenerator;
import com.mayabot.t.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;

public class TokenWordTermGenerator
implements WordTermGenerator {
    private MynlpTokenizer tokenizer;
    private ParagraphReader paragraphReader;
    private int baseOffset = 0;
    private int lastTextLength = -1;
    private LinkedList<WordTerm> buffer = new LinkedList();

    public TokenWordTermGenerator(Reader reader, MynlpTokenizer tokenizer) {
        Preconditions.checkNotNull(tokenizer);
        Preconditions.checkNotNull(reader);
        this.setReader(reader);
        this.tokenizer = tokenizer;
    }

    public TokenWordTermGenerator(String text, MynlpTokenizer tokenizer) {
        Preconditions.checkNotNull(tokenizer);
        Preconditions.checkNotNull(text);
        this.setString(text);
        this.tokenizer = tokenizer;
    }

    @Override
    public WordTerm nextWord() {
        WordTerm term2;
        if (this.buffer.isEmpty()) {
            String paragraph;
            try {
                paragraph = this.paragraphReader.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (paragraph == null || paragraph.isEmpty()) {
                return null;
            }
            if (this.lastTextLength == -1) {
                this.baseOffset = 0;
                this.lastTextLength = 0;
            } else {
                this.baseOffset = this.lastTextLength;
            }
            this.lastTextLength += paragraph.length();
            char[] text = paragraph.toCharArray();
            this.tokenizer.token(text, term -> this.buffer.add((WordTerm)term));
        }
        if ((term2 = this.buffer.pop()) == null) {
            return null;
        }
        if (this.baseOffset != 0) {
            term2.setOffset(term2.getOffset() + this.baseOffset);
        }
        return term2;
    }

    private void setReader(Reader reader) {
        this.paragraphReader = new ParagraphReaderSmart(new FastCharReader(reader, 128), 1024);
        this.baseOffset = 0;
        this.lastTextLength = -1;
    }

    private void setString(String text) {
        this.paragraphReader = new ParagraphReaderString(text);
        this.baseOffset = 0;
        this.lastTextLength = -1;
    }
}

