/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.core;

import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.common.matrix.CSRSparseMatrix;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.resources.NlpResouceExternalizable;
import com.mayabot.nlp.segment.core.CoreDictionary;
import com.mayabot.t.google.common.base.Charsets;
import com.mayabot.t.google.common.base.Preconditions;
import com.mayabot.t.google.common.base.Splitter;
import com.mayabot.t.google.common.collect.TreeBasedTable;
import com.mayabot.t.google.common.hash.Hashing;
import com.mayabot.t.google.common.primitives.Ints;
import com.mayabot.t.google.inject.Inject;
import com.mayabot.t.google.inject.Singleton;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@Singleton
public class CoreBiGramTableDictionary
extends NlpResouceExternalizable {
    private CSRSparseMatrix matrix;
    public final String path = "core-dict/CoreDict.bigram.txt";
    protected InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private final CoreDictionary coreDictionary;

    @Inject
    public CoreBiGramTableDictionary(CoreDictionary coreDictionary, MynlpEnv mynlp) throws Exception {
        this.coreDictionary = coreDictionary;
        this.restore(mynlp);
    }

    @Override
    public String sourceVersion(MynlpEnv mynlp) {
        return Hashing.murmur3_32().newHasher().putString(mynlp.hashResource("core-dict/CoreDict.bigram.txt"), Charsets.UTF_8).putString("v2", Charsets.UTF_8).hash().toString();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void loadFromSource(MynlpEnv mynlp) throws Exception {
        source = mynlp.loadResource("core-dict/CoreDict.bigram.txt");
        Preconditions.checkNotNull(source);
        table = TreeBasedTable.create();
        splitter = Splitter.on(" ").omitEmptyStrings().trimResults();
        firstWord = null;
        count = 0;
        reader = source.openLineReader();
        var8_8 = null;
lbl10:
        // 2 sources

        try {
            while (reader.hasNext()) {
                block15: {
                    line = (String)reader.next();
                    if (!line.startsWith("\t")) break block15;
                    firstWh = line.indexOf(" ");
                    numString = line.substring(1, firstWh);
                    num = Ints.tryParse(numString);
                    words = splitter.splitToList(line.substring(firstWh + 1));
                    wordA = firstWord;
                    idA = this.coreDictionary.wordId(wordA);
                    if (idA == -1) continue;
                    for (String wordB : words) {
                        idB = this.coreDictionary.wordId(wordB);
                        if (idB < 0) continue;
                        table.put((Object)idA, (Object)idB, (Object)num);
                        ++count;
                    }
                    ** GOTO lbl10
                }
                firstWord = line;
            }
        }
        catch (Throwable var9_11) {
            var8_8 = var9_11;
            throw var9_11;
        }
        finally {
            if (reader != null) {
                if (var8_8 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable var9_10) {
                        var8_8.addSuppressed(var9_10);
                    }
                } else {
                    reader.close();
                }
            }
        }
        this.logger.info("Core biGram pair size " + count);
        this.matrix = new CSRSparseMatrix(table, this.coreDictionary.size());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.matrix.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.matrix = new CSRSparseMatrix();
        this.matrix.readExternal(in);
    }

    public int getBiFrequency(String a, String b) {
        int idA = this.coreDictionary.getWordID(a);
        if (idA < 0) {
            return 0;
        }
        int idB = this.coreDictionary.getWordID(b);
        if (idB < 0) {
            return 0;
        }
        return this.matrix.get(idA, idB);
    }

    public int getBiFrequency(int idA, int idB) {
        return this.matrix.get(idA, idB);
    }
}

