/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.core;

import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.collection.dat.DoubleArrayTrieStringIntMap;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.resources.NlpResouceExternalizable;
import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.nlp.segment.core.DictionaryAbsWords;
import com.mayabot.nlp.utils.CharSourceLineReader;
import com.mayabot.t.google.common.base.Charsets;
import com.mayabot.t.google.common.hash.Hashing;
import com.mayabot.t.google.inject.Inject;
import com.mayabot.t.google.inject.Singleton;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.TreeMap;

@Singleton
public class CoreDictionary
extends NlpResouceExternalizable {
    private InternalLogger logger = InternalLoggerFactory.getInstance(CoreDictionary.class);
    public final String path = "core-dict/CoreDict.txt";
    public int totalFreq;
    private DoubleArrayTrieStringIntMap trie;

    @Inject
    public CoreDictionary(MynlpEnv mynlp) throws Exception {
        this.restore(mynlp);
    }

    @Override
    public void loadFromSource(MynlpEnv mynlp) throws Exception {
        NlpResource dictResource = mynlp.loadResource("core-dict/CoreDict.txt");
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        int maxFreq = 0;
        try (CharSourceLineReader reader = dictResource.openLineReader();){
            while (reader.hasNext()) {
                String line = (String)reader.next();
                String[] param = line.split("\\s");
                Integer count = Integer.valueOf(param[1]);
                map.put(param[0], count);
                maxFreq += count.intValue();
            }
        }
        this.totalFreq = maxFreq;
        for (String label : DictionaryAbsWords.allLabel()) {
            if (map.containsKey(label)) continue;
            map.put(label, 1);
        }
        if (map.isEmpty()) {
            throw new RuntimeException("not found core dict file ");
        }
        this.trie = new DoubleArrayTrieStringIntMap(map);
    }

    @Override
    public String sourceVersion(MynlpEnv mynlp) {
        return Hashing.murmur3_32().newHasher().putString(mynlp.hashResource("core-dict/CoreDict.txt"), Charsets.UTF_8).putString("v2", Charsets.UTF_8).hash().toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.totalFreq);
        this.trie.save(out);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.totalFreq = in.readInt();
        this.trie = new DoubleArrayTrieStringIntMap(in);
    }

    public int wordFreq(String key) {
        int c = this.trie.get(key);
        if (c == -1) {
            c = 0;
        }
        return c;
    }

    public int wordFreq(int wordID) {
        return this.trie.get(wordID);
    }

    public int wordId(CharSequence key) {
        return this.trie.indexOf(key);
    }

    public int wordId(CharSequence key, int pos, int len, int nodePos) {
        return this.trie.indexOf(key, pos, len, nodePos);
    }

    public int wordId(char[] chars, int pos, int len) {
        return this.trie.indexOf(chars, pos, len);
    }

    public int wordId(char[] keyChars, int pos, int len, int nodePos) {
        return this.trie.indexOf(keyChars, pos, len, nodePos);
    }

    public boolean contains(String key) {
        return this.trie.indexOf(key) >= 0;
    }

    public int getWordID(String word) {
        return this.trie.indexOf(word);
    }

    public DoubleArrayTrieStringIntMap.DATMapMatcherInt match(char[] text, int offset) {
        return this.trie.match(text, offset);
    }

    public int size() {
        return this.trie.size();
    }
}

