/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.core;

import com.mayabot.nlp.collection.dat.DoubleArrayTrieStringIntMap;
import com.mayabot.nlp.segment.WordSplitAlgorithm;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.core.CoreDictionary;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import com.mayabot.t.google.inject.Inject;

public class CoreDictionarySplitAlgorithm
extends BaseSegmentComponent
implements WordSplitAlgorithm {
    private CoreDictionary coreDictionary;

    @Inject
    public CoreDictionarySplitAlgorithm(CoreDictionary coreDictionary) {
        this.coreDictionary = coreDictionary;
        this.setOrder(-10000);
    }

    @Override
    public void fill(Wordnet wordnet) {
        char[] text = wordnet.getCharArray();
        DoubleArrayTrieStringIntMap.DATMapMatcherInt searcher = this.coreDictionary.match(text, 0);
        while (searcher.next()) {
            int offset = searcher.getBegin();
            int length = searcher.getLength();
            int wordId = searcher.getIndex();
            Vertex v = new Vertex(length, wordId, searcher.getValue());
            wordnet.put(offset, v);
        }
    }
}

