/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.core;

import com.mayabot.nlp.segment.PipelineTokenizerBuilder;
import com.mayabot.nlp.segment.core.CoreDictionarySplitAlgorithm;
import com.mayabot.nlp.segment.core.ViterbiBestPathAlgorithm;
import com.mayabot.nlp.segment.plugins.AtomSplitAlgorithm;
import com.mayabot.nlp.segment.plugins.Correction;
import com.mayabot.nlp.segment.plugins.CustomDictionaryRecognition;
import com.mayabot.nlp.segment.plugins.NERRecognition;
import com.mayabot.nlp.segment.plugins.PartOfSpeechTagging;
import com.mayabot.nlp.segment.plugins.PersonNameRecognition;
import com.mayabot.nlp.segment.plugins.correction.CorrectionWordpathProcessor;
import com.mayabot.nlp.segment.plugins.customwords.CustomDictionaryProcessor;
import com.mayabot.nlp.segment.plugins.ner.NerProcessor;
import com.mayabot.nlp.segment.plugins.personname.PersonNameAlgorithm;
import com.mayabot.nlp.segment.plugins.pos.PosPerceptronProcessor;
import org.jetbrains.annotations.NotNull;

public class CoreTokenizerBuilder
extends PipelineTokenizerBuilder
implements PersonNameRecognition,
NERRecognition,
CustomDictionaryRecognition,
PartOfSpeechTagging,
Correction {
    private boolean enablePersonName = true;
    private boolean enablePOS = true;
    private boolean enableCorrection = true;
    private boolean enableNER = false;
    private boolean enableCustomDictionary = false;

    public static CoreTokenizerBuilder builder() {
        return new CoreTokenizerBuilder();
    }

    @Override
    protected void setUp() {
        this.setBestPathComputer(ViterbiBestPathAlgorithm.class);
        this.addWordSplitAlgorithm(CoreDictionarySplitAlgorithm.class);
        this.addWordSplitAlgorithm(AtomSplitAlgorithm.class);
        if (this.enablePersonName) {
            this.addWordSplitAlgorithm(PersonNameAlgorithm.class);
        }
        if (this.enableCustomDictionary) {
            this.addProcessor(CustomDictionaryProcessor.class);
        }
        if (this.enableCorrection) {
            this.addProcessor(CorrectionWordpathProcessor.class);
        }
        if (this.enablePOS || this.enableNER) {
            this.addProcessor(PosPerceptronProcessor.class);
        }
        if (this.enableNER) {
            this.addProcessor(NerProcessor.class);
        }
    }

    public boolean isEnablePersonName() {
        return this.enablePersonName;
    }

    @Override
    @NotNull
    public CoreTokenizerBuilder setEnablePersonName(boolean enablePersonName) {
        this.enablePersonName = enablePersonName;
        return this;
    }

    public boolean isEnableNER() {
        return this.enableNER;
    }

    @Override
    @NotNull
    public CoreTokenizerBuilder setEnableNER(boolean enableNER) {
        this.enableNER = enableNER;
        return this;
    }

    public boolean isEnableCustomDictionary() {
        return this.enableCustomDictionary;
    }

    @Override
    @NotNull
    public CoreTokenizerBuilder setEnableCustomDictionary(boolean enableCustomDictionary) {
        this.enableCustomDictionary = enableCustomDictionary;
        return this;
    }

    public boolean isEnablePOS() {
        return this.enablePOS;
    }

    @Override
    @NotNull
    public CoreTokenizerBuilder setEnablePOS(boolean enablePOS) {
        this.enablePOS = enablePOS;
        return this;
    }

    public boolean isEnableCorrection() {
        return this.enableCorrection;
    }

    @Override
    @NotNull
    public CoreTokenizerBuilder setEnableCorrection(boolean enableCorrection) {
        this.enableCorrection = enableCorrection;
        return this;
    }
}

