/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.crf;

import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronModel;
import com.mayabot.nlp.segment.crf.CWSCrfFeature;
import com.mayabot.nlp.segment.crf.FeatureTemplateGroup;
import com.mayabot.nlp.utils.CharNormUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u0016\u001a\u00020\u0006R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/mayabot/nlp/segment/crf/CWSCrf;", "", "model", "Lcom/mayabot/nlp/perceptron/Perceptron;", "labelList", "", "", "featureTemplateGroup", "Lcom/mayabot/nlp/segment/crf/FeatureTemplateGroup;", "(Lcom/mayabot/nlp/perceptron/Perceptron;[Ljava/lang/String;Lcom/mayabot/nlp/segment/crf/FeatureTemplateGroup;)V", "E_ID", "", "S_ID", "getFeatureTemplateGroup", "()Lcom/mayabot/nlp/segment/crf/FeatureTemplateGroup;", "getLabelList", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getModel", "()Lcom/mayabot/nlp/perceptron/Perceptron;", "decode", "", "sentence", "", "convert", "", "decodeToWordList", "", "Companion", "mynlp-segment"})
public final class CWSCrf {
    private final int S_ID;
    private final int E_ID;
    @NotNull
    private final Perceptron model;
    @NotNull
    private final String[] labelList;
    @NotNull
    private final FeatureTemplateGroup featureTemplateGroup;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> decodeToWordList(@NotNull String sentence) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        ArrayList result = new ArrayList();
        String string = sentence;
        CWSCrf cWSCrf = this;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        int[] decode = cWSCrf.decode(cArray2, true);
        int p = 0;
        int n = 0;
        int n2 = decode.length;
        while (n < n2) {
            void i;
            int f = decode[i];
            if (f == this.S_ID || f == this.E_ID) {
                Collection collection = result;
                String string2 = sentence;
                void var10_15 = i + true;
                String string3 = string2.substring(p, (int)var10_15);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string2 = string3;
                collection.add(string2);
                p = i + true;
            }
            ++i;
        }
        if (p < sentence.length()) {
            Collection collection = result;
            String string4 = sentence;
            int n3 = sentence.length();
            String string5 = string4.substring(p, n3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string4 = string5;
            collection.add(string4);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] decode(@NotNull char[] sentence, boolean convert) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        if (convert) {
            CharNormUtils.convert(sentence);
        }
        StringBuilder buffer = new StringBuilder();
        ArrayList featureList = new ArrayList(sentence.length);
        int n = 0;
        int n2 = sentence.length;
        while (n < n2) {
            void i;
            Collection collection = featureList;
            FeatureSet featureSet = this.model.featureSet();
            Intrinsics.checkExpressionValueIsNotNull((Object)featureSet, (String)"model.featureSet()");
            IntArrayList intArrayList = CWSCrfFeature.INSTANCE.extractFeatureVector(sentence, (int)i, featureSet, this.featureTemplateGroup, buffer);
            collection.add(intArrayList);
            ++i;
        }
        int[] nArray = this.model.decode(featureList);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray, (String)"model.decode(featureList)");
        return nArray;
    }

    @NotNull
    public final Perceptron getModel() {
        return this.model;
    }

    @NotNull
    public final String[] getLabelList() {
        return this.labelList;
    }

    @NotNull
    public final FeatureTemplateGroup getFeatureTemplateGroup() {
        return this.featureTemplateGroup;
    }

    /*
     * WARNING - void declaration
     */
    public CWSCrf(@NotNull Perceptron model, @NotNull String[] labelList, @NotNull FeatureTemplateGroup featureTemplateGroup) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)labelList, (String)"labelList");
        Intrinsics.checkParameterIsNotNull((Object)featureTemplateGroup, (String)"featureTemplateGroup");
        this.model = model;
        this.labelList = labelList;
        this.featureTemplateGroup = featureTemplateGroup;
        int s_id = 0;
        int e_id = 0;
        String[] $receiver$iv = this.labelList;
        int index$iv = 0;
        for (String item$iv : $receiver$iv) {
            void s;
            int n = index$iv++;
            String string = item$iv;
            int index = n;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)s, (Object)"S")) {
                s_id = index;
            }
            if (!Intrinsics.areEqual((Object)s, (Object)"E")) continue;
            e_id = index;
        }
        this.S_ID = s_id;
        this.E_ID = e_id;
    }

    @JvmStatic
    @NotNull
    public static final CWSCrf load(@NotNull File dir) {
        return Companion.load(dir);
    }

    @JvmStatic
    @NotNull
    public static final CWSCrf load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, @NotNull InputStream labelText, @NotNull InputStream featureTemplate) {
        return Companion.load(parameterBin, featureBin, labelText, featureTemplate);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0007\u00a8\u0006\f"}, d2={"Lcom/mayabot/nlp/segment/crf/CWSCrf$Companion;", "", "()V", "load", "Lcom/mayabot/nlp/segment/crf/CWSCrf;", "dir", "Ljava/io/File;", "parameterBin", "Ljava/io/InputStream;", "featureBin", "labelText", "featureTemplate", "mynlp-segment"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final CWSCrf load(@NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Object object = new File(dir, "parameter.bin");
            object = new FileInputStream((File)object);
            int n = 8192;
            BufferedInputStream parameterBin = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Object object2 = new File(dir, "feature.dat");
            object2 = new FileInputStream((File)object2);
            int n2 = 8192;
            BufferedInputStream featureBin = object2 instanceof BufferedInputStream ? (BufferedInputStream)object2 : new BufferedInputStream((InputStream)object2, n2);
            Object object3 = new File(dir, "label.txt");
            object3 = new FileInputStream((File)object3);
            int n3 = 8192;
            BufferedInputStream labelText = object3 instanceof BufferedInputStream ? (BufferedInputStream)object3 : new BufferedInputStream((InputStream)object3, n3);
            Object object4 = new File(dir, "featureTemplate.txt");
            object4 = new FileInputStream((File)object4);
            int n4 = 8192;
            BufferedInputStream featureTemplate = object4 instanceof BufferedInputStream ? (BufferedInputStream)object4 : new BufferedInputStream((InputStream)object4, n4);
            return this.load(parameterBin, featureBin, labelText, featureTemplate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final CWSCrf load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, @NotNull InputStream labelText, @NotNull InputStream featureTemplate) {
            void $receiver$iv;
            Object object;
            Object object2;
            Object object3;
            Object it2;
            Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
            Intrinsics.checkParameterIsNotNull((Object)featureBin, (String)"featureBin");
            Intrinsics.checkParameterIsNotNull((Object)labelText, (String)"labelText");
            Intrinsics.checkParameterIsNotNull((Object)featureTemplate, (String)"featureTemplate");
            PerceptronModel model = PerceptronModel.Companion.load(parameterBin, featureBin, true);
            Closeable closeable = labelText;
            Object object4 = null;
            try {
                it2 = (InputStream)closeable;
                boolean bl = false;
                InputStream inputStream = it2;
                object3 = Charsets.UTF_8;
                object2 = inputStream;
                object2 = new InputStreamReader((InputStream)object2, (Charset)object3);
                int n = 8192;
                it2 = TextStreamsKt.readLines((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n)));
            }
            catch (Throwable it2) {
                object4 = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object4);
            }
            Object labelList = it2;
            object4 = featureTemplate;
            it2 = null;
            try {
                Object it3 = (InputStream)object4;
                boolean bl = false;
                object3 = it3;
                object2 = Charsets.UTF_8;
                Object object5 = object3;
                object5 = new InputStreamReader((InputStream)object5, (Charset)object2);
                int n = 8192;
                it3 = TextStreamsKt.readLines((Reader)(object5 instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, n)));
            }
            catch (Throwable it3) {
                it2 = it3;
                throw it3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object4, (Throwable)it2);
            }
            Object object6 = object = it3;
            FeatureTemplateGroup featureTemplateGroup = new FeatureTemplateGroup((List<String>)object6);
            object4 = (Collection)labelList;
            object = model;
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v0;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            FeatureTemplateGroup featureTemplateGroup2 = featureTemplateGroup;
            String[] stringArray3 = stringArray2;
            Object object7 = object;
            return new CWSCrf((Perceptron)object7, stringArray3, featureTemplateGroup2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

