/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.crf;

import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronModel;
import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.crf.FeatureTemplateGroup;
import com.mayabot.nlp.segment.crf.NerCrfFeature;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019R\u0019\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/mayabot/nlp/segment/crf/NerCrf;", "", "model", "Lcom/mayabot/nlp/perceptron/Perceptron;", "labels", "", "", "featureTemplateGroup", "Lcom/mayabot/nlp/segment/crf/FeatureTemplateGroup;", "(Lcom/mayabot/nlp/perceptron/Perceptron;[Ljava/lang/String;Lcom/mayabot/nlp/segment/crf/FeatureTemplateGroup;)V", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "kotlin.jvm.PlatformType", "getFeatureSet", "()Lcom/mayabot/nlp/perceptron/FeatureSet;", "getFeatureTemplateGroup", "()Lcom/mayabot/nlp/segment/crf/FeatureTemplateGroup;", "getLabels", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getModel", "()Lcom/mayabot/nlp/perceptron/Perceptron;", "decode", "", "sentence", "", "Lcom/mayabot/nlp/segment/WordTerm;", "Companion", "mynlp-segment"})
public final class NerCrf {
    private final FeatureSet featureSet;
    @NotNull
    private final Perceptron model;
    @NotNull
    private final String[] labels;
    @NotNull
    private final FeatureTemplateGroup featureTemplateGroup;
    public static final Companion Companion = new Companion(null);

    public final FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    /*
     * WARNING - void declaration
     */
    public final void decode(@NotNull List<WordTerm> sentence) {
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        StringBuilder buffer = new StringBuilder();
        ArrayList featureList = new ArrayList(sentence.size());
        int n = 0;
        int n2 = sentence.size();
        while (n < n2) {
            void i;
            Collection collection = featureList;
            FeatureSet featureSet = this.featureSet;
            Intrinsics.checkExpressionValueIsNotNull((Object)featureSet, (String)"featureSet");
            IntArrayList intArrayList = NerCrfFeature.INSTANCE.extractFeatureVector(sentence, (int)i, featureSet, this.featureTemplateGroup, buffer);
            collection.add(intArrayList);
            ++i;
        }
        int[] result = this.model.decode(featureList);
        n2 = 0;
        int n3 = sentence.size();
        while (n2 < n3) {
            void i;
            sentence.get((int)i).setCustomFlag(this.labels[result[i]]);
            ++i;
        }
    }

    @NotNull
    public final Perceptron getModel() {
        return this.model;
    }

    @NotNull
    public final String[] getLabels() {
        return this.labels;
    }

    @NotNull
    public final FeatureTemplateGroup getFeatureTemplateGroup() {
        return this.featureTemplateGroup;
    }

    public NerCrf(@NotNull Perceptron model, @NotNull String[] labels, @NotNull FeatureTemplateGroup featureTemplateGroup) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)labels, (String)"labels");
        Intrinsics.checkParameterIsNotNull((Object)featureTemplateGroup, (String)"featureTemplateGroup");
        this.model = model;
        this.labels = labels;
        this.featureTemplateGroup = featureTemplateGroup;
        this.featureSet = this.model.featureSet();
    }

    @JvmStatic
    @NotNull
    public static final NerCrf load(@NotNull File dir) {
        return Companion.load(dir);
    }

    @JvmStatic
    @NotNull
    public static final NerCrf load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, @NotNull InputStream labelText, @NotNull InputStream featureTemplate) {
        return Companion.load(parameterBin, featureBin, labelText, featureTemplate);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0007\u00a8\u0006\f"}, d2={"Lcom/mayabot/nlp/segment/crf/NerCrf$Companion;", "", "()V", "load", "Lcom/mayabot/nlp/segment/crf/NerCrf;", "dir", "Ljava/io/File;", "parameterBin", "Ljava/io/InputStream;", "featureBin", "labelText", "featureTemplate", "mynlp-segment"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final NerCrf load(@NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Object object = new File(dir, "parameter.bin");
            object = new FileInputStream((File)object);
            int n = 8192;
            BufferedInputStream parameterBin = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Object object2 = new File(dir, "feature.dat");
            object2 = new FileInputStream((File)object2);
            int n2 = 8192;
            BufferedInputStream featureBin = object2 instanceof BufferedInputStream ? (BufferedInputStream)object2 : new BufferedInputStream((InputStream)object2, n2);
            Object object3 = new File(dir, "label.txt");
            object3 = new FileInputStream((File)object3);
            int n3 = 8192;
            BufferedInputStream labelText = object3 instanceof BufferedInputStream ? (BufferedInputStream)object3 : new BufferedInputStream((InputStream)object3, n3);
            Object object4 = new File(dir, "featureTemplate.txt");
            object4 = new FileInputStream((File)object4);
            int n4 = 8192;
            BufferedInputStream featureTemplate = object4 instanceof BufferedInputStream ? (BufferedInputStream)object4 : new BufferedInputStream((InputStream)object4, n4);
            return this.load(parameterBin, featureBin, labelText, featureTemplate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final NerCrf load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, @NotNull InputStream labelText, @NotNull InputStream featureTemplate) {
            void $receiver$iv;
            Object object;
            Object object2;
            Object object3;
            Object it2;
            Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
            Intrinsics.checkParameterIsNotNull((Object)featureBin, (String)"featureBin");
            Intrinsics.checkParameterIsNotNull((Object)labelText, (String)"labelText");
            Intrinsics.checkParameterIsNotNull((Object)featureTemplate, (String)"featureTemplate");
            PerceptronModel model = PerceptronModel.Companion.load(parameterBin, featureBin, true);
            Closeable closeable = labelText;
            Object object4 = null;
            try {
                it2 = (InputStream)closeable;
                boolean bl = false;
                InputStream inputStream = it2;
                object3 = Charsets.UTF_8;
                object2 = inputStream;
                object2 = new InputStreamReader((InputStream)object2, (Charset)object3);
                int n = 8192;
                it2 = TextStreamsKt.readLines((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n)));
            }
            catch (Throwable it2) {
                object4 = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object4);
            }
            Object labelList = it2;
            object4 = featureTemplate;
            it2 = null;
            try {
                Object it3 = (InputStream)object4;
                boolean bl = false;
                object3 = it3;
                object2 = Charsets.UTF_8;
                Object object5 = object3;
                object5 = new InputStreamReader((InputStream)object5, (Charset)object2);
                int n = 8192;
                it3 = TextStreamsKt.readLines((Reader)(object5 instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, n)));
            }
            catch (Throwable it3) {
                it2 = it3;
                throw it3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object4, (Throwable)it2);
            }
            Object object6 = object = it3;
            FeatureTemplateGroup featureTemplateGroup = new FeatureTemplateGroup((List<String>)object6);
            object4 = (Collection)labelList;
            object = model;
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v0;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            FeatureTemplateGroup featureTemplateGroup2 = featureTemplateGroup;
            String[] stringArray3 = stringArray2;
            Object object7 = object;
            return new NerCrf((Perceptron)object7, stringArray3, featureTemplateGroup2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

